// ScriptEngine.cpp : implementation file
//

#include "stdafx.h"
#include "script.h"
#include "ScriptEngine.h"
//#include "outputdialog.h"
#include "outputwindow.h"
#include "scriptdoc.h"
#include "scriptview.h"
#include "utility.h"
#include "IntrinsicControl.h"
//#include "IntrinsicControl2Ctl.h"
#include "BreakpointDialog.h"
#include "notify.h"
#include "FullScreen.h"
#include <WINIOCTL.H>

#define HIGHID	16383
#define ALLOCSIZE	100
#define FOCUSBORDER 2


extern "C" __declspec(dllimport) BOOL KernelIoControl( DWORD	dwIoControlCode,
													   LPVOID	lpInBuf,
													   DWORD	nInBufSize,
													   LPVOID	lpOutBuf,
													   DWORD	nOutBufSize,
													   LPDWORD	lpBytesReturned );

#define IOCTL_HAL_GET_DEVICEID CTL_CODE(FILE_DEVICE_HAL, 21, METHOD_BUFFERED, FILE_ANY_ACCESS)

#if _WIN32_WCE >= 300 && defined(_POCKET) && !defined(_WIN32_WCE_HPC)
#include "Aygshell.h"
#endif

#undef _DEBUG // EMP DIKEO

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define kScriptEngineObjectName TEXT("ScriptEngine")

extern HWND ghwndMain;
//extern CWnd cwnd;
extern class COutputWindow *gpOutputWindow;
extern UINT giNextMenuID;
extern CScriptApp theApp;
extern bool gbForceAllowOpen;
extern bool gbEnterModalLoop;
extern bool gbScrollToError;
extern HCURSOR ghCursorNormal;

extern BOOL gbTrace;
extern BOOL gbStep;

bool gbExitException;
bool gbOverrideRunActivate=false;

#ifdef JSCRIPT
#define SCRIPTING_ENGINE_GUID OLESTR("{f414c260-6ac0-11cf-b6d1-00aa00bbbb58}")
#else
#define SCRIPTING_ENGINE_GUID OLESTR("{B54F3741-5B07-11cf-A4B0-00AA004A55E8}")
#endif

// DIKEO KLUDGE
//#define UDS_EXPANDABLE 0

#if 0
IntrinsicObject gaIntrinsicObjects[]={
	{IntrinsicButton,TEXT("commandbutton"),TEXT("button"),WS_VISIBLE|WS_CHILD|BS_PUSHBUTTON,0},
	{IntrinsicEdit,TEXT("textbox"),TEXT("edit"),WS_VISIBLE|WS_CHILD,0},
	{IntrinsicCheck,TEXT("checkbox"),TEXT("button"),WS_VISIBLE|WS_CHILD|BS_AUTOCHECKBOX,0},
	{IntrinsicRadio,TEXT("optionbutton"),TEXT("button"),WS_VISIBLE|WS_CHILD|WS_GROUP,0},
	{IntrinsicList,TEXT("listbox"),TEXT("listbox"),WS_VISIBLE|WS_CHILD,0},
	{IntrinsicCombo,TEXT("combobox"),TEXT("combobox"),WS_VISIBLE|WS_CHILD,0},
	{IntrinsicStatic,TEXT("label"),TEXT("static"),WS_VISIBLE|WS_CHILD|SS_LEFT|SS_NOTIFY,0},
	{IntrinsicDate,TEXT("date"),DATETIMEPICK_CLASS ,WS_VISIBLE|WS_CHILD,0},
	{IntrinsicTime,TEXT("time"),DATETIMEPICK_CLASS ,WS_VISIBLE|WS_CHILD|DTS_TIMEFORMAT,0},
	{IntrinsicFrame,TEXT("frame"),TEXT("button"),WS_VISIBLE|WS_CHILD|BS_GROUPBOX,0},
	{IntrinsicTriButton,TEXT("tributton"),TEXT("button"),WS_VISIBLE|WS_CHILD|BS_AUTO3STATE,0},
	{IntrinsicHScrollBar,TEXT("hscrollbar"),TEXT("scrollbar"),WS_VISIBLE|WS_CHILD|SBS_HORZ|0x0002L,0},
	{IntrinsicVScrollBar,TEXT("vscrollbar"),TEXT("scrollbar"),WS_VISIBLE|WS_CHILD|SBS_VERT|0x0002L,0},
	{IntrinsicSpinBox,TEXT("spinbox"),UPDOWN_CLASS,WS_VISIBLE|WS_CHILD|UDS_HORZ|UDS_ALIGNRIGHT|UDS_ARROWKEYS|UDS_SETBUDDYINT|UDS_EXPANDABLE|UDS_WRAP,0}
			};
#else
IntrinsicObject gaIntrinsicObjects[]={
	{IntrinsicButton,TEXT("commandbutton"),TEXT("button"),WS_VISIBLE|WS_CHILD|WS_TABSTOP|BS_PUSHBUTTON,0},
	{IntrinsicEdit,TEXT("textbox"),TEXT("edit"),WS_VISIBLE|WS_CHILD|WS_TABSTOP,0},
	{IntrinsicCheck,TEXT("checkbox"),TEXT("button"),WS_VISIBLE|WS_CHILD|WS_TABSTOP|BS_AUTOCHECKBOX,0},
	{IntrinsicRadio,TEXT("optionbutton"),TEXT("button"),WS_VISIBLE|WS_CHILD|WS_TABSTOP|WS_GROUP,0},
	{IntrinsicList,TEXT("listbox"),TEXT("listbox"),WS_VISIBLE|WS_CHILD|WS_TABSTOP,0},
	{IntrinsicCombo,TEXT("combobox"),TEXT("combobox"),WS_VISIBLE|WS_CHILD|WS_TABSTOP,0},
	{IntrinsicStatic,TEXT("label"),TEXT("static"),WS_VISIBLE|WS_CHILD|SS_LEFT|SS_NOTIFY,0},
	{IntrinsicDate,TEXT("date"),DATETIMEPICK_CLASS ,WS_VISIBLE|WS_TABSTOP|WS_CHILD,0},
	{IntrinsicTime,TEXT("time"),DATETIMEPICK_CLASS ,WS_VISIBLE|WS_TABSTOP|WS_CHILD|DTS_TIMEFORMAT,0},
	{IntrinsicFrame,TEXT("frame"),TEXT("button"),WS_VISIBLE|WS_CHILD|BS_GROUPBOX,0},
	{IntrinsicTriButton,TEXT("tributton"),TEXT("button"),WS_VISIBLE|WS_CHILD|WS_TABSTOP|BS_AUTO3STATE,0},
	{IntrinsicHScrollBar,TEXT("hscrollbar"),TEXT("scrollbar"),WS_VISIBLE|WS_CHILD|WS_TABSTOP|SBS_HORZ|0x0002L,0},
	{IntrinsicVScrollBar,TEXT("vscrollbar"),TEXT("scrollbar"),WS_VISIBLE|WS_CHILD|WS_TABSTOP|SBS_VERT|0x0002L,0},
	{IntrinsicFocusRect,TEXT("focusrect"),TEXT("static"),WS_VISIBLE|WS_CHILD|WS_TABSTOP,0},
	{IntrinsicSpinBox,TEXT("spinbox"),UPDOWN_CLASS,WS_VISIBLE|WS_CHILD|WS_TABSTOP|UDS_HORZ|UDS_ALIGNRIGHT|UDS_ARROWKEYS|UDS_SETBUDDYINT|UDS_EXPANDABLE|UDS_WRAP,0}
			};
//	{IntrinsicFrame,TEXT("frame"),TEXT("button"),0x50000007,0},
#endif

template <CScriptObject> void AFXAPI ConstructElements /*<CScriptObject>*/ ( CScriptObject* pNew, int nCount )
{   
	for ( int i = 0; i < nCount; i++, pNew++ )    
	{
		new( pNew )CScriptObject; 
	}
}
template <CScriptObject> void AFXAPI DestructElements /*<CScriptObject>*/ ( CScriptObject* pNew, int nCount )
{    for ( int i = 0; i < nCount; i++, pNew++ )    
	{
		pNew->~CScriptObject();

		int i; 

		//DebugStr(L"DestructElement - %s\n",pNew->cstrLabel);
		
		if(!(pNew->dwFlags&OBJ_ISWINDOW) && pNew->pUnk) 
		{
			DebugRefCount(pNew->pUnk,L"(non-window object)");
			i=pNew->pUnk->Release(); 
			DebugStr(L"Destroyed item %s with refcount %i\n",pNew->cstrLabel,i);
			pNew->pUnk=0;
		}
		//we don't explicitly release others, because any references are being held
		//by the window, which will be destroyed by the output dialog..

		return;
		//this code here cause beacoup trouble.  Something having to do
		//with the order of destruction, or something.  In any case,  when
		//the parent window is destroyed, all of the little kiddies will
		//be destroyed with it.
		if(pNew->pCWnd)
		{
			DebugRefCount(pNew->pUnk,L"(window object)");
			//pNew->pUnk->Release();
			//DebugRefCount(pNew->pUnk,L"DestructElement window object");
			pNew->pCWnd->DestroyWindow();
			//DebugRefCount(pNew->pUnk,L"DestructElement window object");
			delete(pNew->pCWnd);
		}
    }
}
CScriptObject::CScriptObject() {/*hWnd=0;*/ pUnk=NULL; pCWnd=0; cstrLabel.Empty();};
CScriptObject::~CScriptObject() {};

/////////////////////////////////////////////////////////////////////////////
// CDictionary
CDictionary::CDictionary()
{
	dispatch.parent = this;
	ref = 0;
	nextID = HIGHID;
	bindings = NULL;
	symbolsAsTree = NULL;
	symbolsAsArray = (SymbolNode **)malloc(ALLOCSIZE * sizeof(SymbolNode *));
	allocedSymbols = ALLOCSIZE;
}

CDictionary::~CDictionary(void)
{
	freeBindings();
}

ULONG CDictionary::AddRef(void) 
{ 
    return ++ref;
}

ULONG CDictionary::Release(void)
{
    if (--ref == 0)
    {
        delete this;
        return 0;
    }
    return ref;
}

HRESULT CDictionary::QueryInterface(
    REFIID iid, void** ppvObj)
{ 
    if (iid == IID_IUnknown)
    {
        *ppvObj = this;
        AddRef();
        return NOERROR;
    }
	else if (iid == IID_IDispatch)
	{
		*ppvObj = &dispatch;
		AddRef();
		return NOERROR;
	}
	else
	{
		return ResultFromScode(E_NOINTERFACE);
	}
}

static long wcscmpu(const wchar_t *a, const wchar_t *b)
{
	long cmp;

	while (*a && *b)
	{
		cmp = toupper(*a) - toupper(*b);
		if (cmp) return cmp;
		++a; ++b;
	}

	if (*a) return *a;
	if (*b) return -*b;
	return 0;
}

DISPID CDictionary::findNameHelper(LPCOLESTR name, bool create, SymbolNode **nodeP)
{
	if (*nodeP)
	{
		long cmp = wcscmpu(name, (*nodeP) -> name);
		if (cmp == 0) return (*nodeP) -> ID;
		else if (cmp < 0) return findNameHelper(name, create, &((*nodeP) -> left));
		else return findNameHelper(name, create, &((*nodeP) -> right));
	}
	else if (create)
	{
		int n = wcslen(name);
		*nodeP = new SymbolNode;
		(*nodeP) -> left = NULL;
		(*nodeP) -> right = NULL;
		(*nodeP) -> ID = nextID--;
		(*nodeP) -> name = new wchar_t[n + 1];
		wcscpy((*nodeP) -> name, name);

		if (HIGHID - nextID >= allocedSymbols)
		{
			allocedSymbols += ALLOCSIZE;
			symbolsAsArray = (SymbolNode **)realloc(symbolsAsArray, allocedSymbols * sizeof(SymbolNode *));
		}
		symbolsAsArray[HIGHID - (*nodeP) -> ID] = *nodeP;

		return (*nodeP) -> ID;
	}
	else
	{
		return DISPID_UNKNOWN;
	}
}

DISPID CDictionary::findName(LPCOLESTR name, bool create)
{
	return findNameHelper(name, create, &symbolsAsTree);
}

bool CDictionary::defDLL(LPCTSTR name, ArgType retArg, Argument *args)
{
	// DIKEO check to see if already there
	DISPID ID = findName(name, true);
	BindingNode *newDLL = new BindingNode();

	newDLL -> ID = ID;
	newDLL -> type = kDLLFunc;
	newDLL -> DLLfunc.retType = retArg;
	newDLL -> DLLfunc.args = args;
	newDLL -> next = bindings;
	bindings = newDLL;

	return true;
}

LPCTSTR CDictionary::getSymbolName(DISPID ID)
{
	if (ID <= HIGHID && ID > nextID)
	{
		return symbolsAsArray[HIGHID - ID] -> name;
	}
	else
	{
		return NULL;
	}
}


void CDictionary::freeBindings(void)
{
	while (NULL != bindings)
	{
		BindingNode *next;
		next = bindings -> next;
		if (kDLLFunc == bindings -> type)
		{
			Argument *argNext;
			while (bindings -> DLLfunc.args)
			{
				argNext = bindings -> DLLfunc.args -> next;
				delete bindings -> DLLfunc.args;
				bindings -> DLLfunc.args = argNext;
			}
		}
		delete bindings;
		bindings = next;
	}
}

BindingNode *CDictionary::findDLL(DISPID dispIdMember)
{
	BindingNode *objs;
	for (objs = bindings; objs; objs = objs -> next)
	{
		if (dispIdMember == objs -> ID && kDLLFunc == objs -> type)
		{
			return objs;
		}
	}
	return NULL;
}


/**********
	CDictionary::Dispatch
  */

HRESULT CDictionary::Dispatch::QueryInterface(REFIID iid, void** ppvObj)
{
    return parent -> QueryInterface(iid, ppvObj); 
}

ULONG CDictionary::Dispatch::AddRef(void) 
{ 
    return parent -> AddRef();
}

ULONG CDictionary::Dispatch::Release(void)
{
    return parent -> Release();
}

HRESULT CDictionary::Dispatch::GetTypeInfoCount(unsigned int FAR*  pctinfo)
{
	*pctinfo = 0;
	return ResultFromScode(E_NOTIMPL);
}

HRESULT CDictionary::Dispatch::GetTypeInfo(unsigned int iTInfo, LCID  lcid, ITypeInfo FAR* FAR*  ppTInfo)
{
	*ppTInfo = NULL;
	return ResultFromScode(E_NOTIMPL);
}

HRESULT CDictionary::Dispatch::GetIDsOfNames(REFIID riid, OLECHAR FAR* FAR* rgszNames, unsigned int cNames, LCID lcid, DISPID FAR* rgDispId)
{
	unsigned int k;
	HRESULT retVal = ResultFromScode(S_OK);

	for (k = 0; k < cNames; ++k)
	{
		LCID ID;

		ID = parent -> findName(rgszNames[k], false);
		if (ID != DISPID_UNKNOWN)
		{
			rgDispId[k] = ID;
		}
		else
		{
			rgDispId[k] = DISPID_UNKNOWN;
			retVal = DISP_E_UNKNOWNNAME;
		}
	}

	return retVal;
}

HRESULT CDictionary::Dispatch::Invoke(DISPID dispIdMember, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR*  pDispParams, VARIANT FAR* pVarResult, EXCEPINFO FAR* pExcepInfo, unsigned int FAR* puArgErr)
{
	return ResultFromScode(E_NOTIMPL);
}

/////////////////////////////////////////////////////////////////////////////
// CLibraryDispatch

CLibraryDispatch::CLibraryDispatch(HINSTANCE lib): library(lib), m_ref(0), magicNumber(0xDEADF00D) 
{
	dictionary = new CDictionary();
}

CLibraryDispatch::~CLibraryDispatch(void)
{
	delete dictionary;
	FreeLibrary(library);
}

ULONG CLibraryDispatch::AddRef(void) 
{ 
    return ++m_ref;
}

ULONG CLibraryDispatch::Release(void)
{
    if (--m_ref == 0)
    {
        delete this;
        return 0;
    }
    return m_ref;
}

HRESULT CLibraryDispatch::QueryInterface(REFIID iid, void** ppvObj)
{
    if (iid == IID_IDispatch || iid == IID_IUnknown)
    {
        *ppvObj = this;
        AddRef();
        return ResultFromScode(S_OK);
    }
	else
	{
		return ResultFromScode(E_NOINTERFACE);
	}
}

void CLibraryDispatch::skipblanks(void)
{
	while (*s && (*s == ' ' || *s == '\t')) ++s;
}

static int ia(wchar_t s)
{
	return ((s >= 'a') && (s <= 'z')) || ((s >= 'A') && (s <= 'Z'));
}

static int id(wchar_t s)
{
	return ((s >= '0') && (s <= '9'));
}

void CLibraryDispatch::nextToken(void)
{
	skipblanks();

	if (*s)
	{
		if (ia(*s))
		{
			wchar_t *s2;
			BSTR i;

			for (s2 = s; ia(*s2) || id(*s2) || '_' == (*s2); ++s2) {}

			i = SysAllocStringLen(s, s2 - s);
			s = s2;
			tokenType = kTTIdentifier;
			token = dictionary -> findName(i, true);

			SysFreeString(i);
		}
		else
		{
			tokenType = kTTOperator;
			token = *s;
			++s;
		}
	}
	else
	{
		tokenType = kTTEOF;
	}
}

BSTR CLibraryDispatch::declaration(DeclKind kind, BSTR strName)
/* <declaration> ::= [(<argument> {,<argument>})] [as <type>]
   Either arg list or type must be present */
{
	int name = dictionary -> findName(strName, true);

	ArgType retType = kArgNone;
	Argument *args = NULL;
	Argument **lastArg = &args;

	nextToken();

	if (kTTOperator == tokenType && '(' == token)
	{
		nextToken();

		while (!(kTTOperator == tokenType && ')' == token))
		{
			bool byRef = false;
			bool array = false;
			ArgType argType;

			if (kTTIdentifier == tokenType && dictionary -> findName(L"ByRef", true) == token)
			{
				nextToken();
				byRef = true;
			}
			else 
			if (kTTIdentifier == tokenType && dictionary -> findName(L"ByVal", true) == token)
			{
				nextToken();
				byRef = false;
			}
			else
			{
				byRef = true;
			}

			if (kTTIdentifier == tokenType)
			{
				nextToken();
			}
			else
			{
				return SysAllocString(L"Missing argument name");
			}

			if (kTTOperator == tokenType && '(' == token)
			{
				array = true;
				nextToken();
				if (kTTOperator != tokenType || ')' != token)
				{
					return SysAllocString(L"Missing close parenthesis");
				}
				nextToken();
			}

			if (kTTIdentifier == tokenType && dictionary -> findName(L"As", true) == token)
			{
				nextToken();
				argType = type();
				if (kArgNone == argType)
				{
					return SysAllocString(L"Bad type");
				}
			}
			else
			{
				argType = kArgVariant;
			}


			if (kTTOperator == tokenType && ',' == token)
			{
				nextToken();
			}

			*lastArg = new Argument();
			(*lastArg) -> byRef = byRef;
			(*lastArg) -> argType = argType;
			(*lastArg) -> next = NULL;
			(*lastArg) -> array = array;
			lastArg = &((*lastArg) -> next);
		}
		nextToken();
	}

	if (kTTIdentifier == tokenType && dictionary -> findName(L"As", true) == token)
	{
		nextToken();
		retType = type();
		if (kArgNone == retType)
		{
			return SysAllocString(L"Bad type");
		}
	}

	if (kTTEOF != tokenType)
	{
		return SysAllocString(L"Extraneous characters at end of declaration");
	}

	if (kDProcedure == kind)
	{
		if (retType != kArgNone)
		{
			return SysAllocString(L"Extraneous return type on procedure");
		}
	}
	else if (kDFunction == kind)
	{
		if (kArgNone == retType)
		{
			retType = kArgVariant;
		}
	}

	const wchar_t *uName;
	uName = dictionary -> getSymbolName(name);

	if (!GetProcAddress(library, uName))
	{
		wchar_t buf[200];	// DIKEOCE
		wsprintf(buf, L"Function or procedure %s is not present in DLL", uName);
		return SysAllocString(buf);
	}

	dictionary -> defDLL(uName, retType, args);

	return NULL;
}

ArgType CLibraryDispatch::type(void)
{
	ArgType retVal = kArgNone;

	if (kTTIdentifier != tokenType)
	{
		return kArgNone;
	}

	if (dictionary -> findName(L"Date", true) == token ||
		dictionary -> findName(L"Time", true) == token) retVal = kArgDate;
	else if (dictionary -> findName(L"Boolean", true) == token) retVal = kArgBoolean;
	else if (dictionary -> findName(L"Byte", true) == token) retVal = kArgByte;
	else if (dictionary -> findName(L"Integer", true) == token) retVal = kArgInteger;
	else if (dictionary -> findName(L"Long", true) == token) retVal = kArgLong;
	else if (dictionary -> findName(L"Single", true) == token) retVal = kArgSingle;
	else if (dictionary -> findName(L"Double", true) == token) retVal = kArgDouble;
	else if (dictionary -> findName(L"CString", true) == token) retVal = kArgString;
	else if (dictionary -> findName(L"String", true) == token) retVal = kArgUString;
	else if (dictionary -> findName(L"BSTR", true) == token) retVal = kArgUString;
	else if (dictionary -> findName(L"Object", true) == token) retVal = kArgObject;
	else if (dictionary -> findName(L"Variant", true) == token) retVal = kArgVariant;


	if (kArgNone != retVal)
	{
		nextToken();
	}

	return retVal;
}

BSTR CLibraryDispatch::Declare(BSTR syntax, DeclKind kind, BSTR name)
{
	this -> s = syntax;

	return declaration(kind, name);
}

HRESULT CLibraryDispatch::Invoke(DISPID dispIDMember, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR*  pDispParams, VARIANT FAR* pVarResult, EXCEPINFO FAR* pExcepInfo, unsigned int FAR* puArgErr)
{
	return doInvocation(dispIDMember, riid, lcid, wFlags, pDispParams, pVarResult, pExcepInfo, puArgErr);
}

HRESULT CLibraryDispatch::GetIDsOfNames(REFIID riid, OLECHAR FAR* FAR* rgszNames, unsigned int cNames, LCID lcid, DISPID FAR* rgDispId)
{
	if (NULL != dictionary)
	{
		IDispatch *disp;
		HRESULT hr;
		
		hr = dictionary -> QueryInterface(IID_IDispatch, (void **)&disp);
		if (SUCCEEDED(hr))
		{
			return disp -> GetIDsOfNames(riid, rgszNames, cNames, lcid, rgDispId);
		}
		else
		{
			return ResultFromScode(E_NOTIMPL);
		}
	}
	else
	{
		return ResultFromScode(E_NOTIMPL);
	}
}

HRESULT CLibraryDispatch::GetTypeInfoCount(unsigned int FAR*  pctinfo)
{
	*pctinfo = 0;
	return ResultFromScode(E_NOTIMPL);
}


HRESULT CLibraryDispatch::GetTypeInfo(unsigned int iTInfo, LCID  lcid, ITypeInfo FAR* FAR*  ppTInfo)
{
	*ppTInfo = NULL;
	return ResultFromScode(E_NOTIMPL);
}

CDictionary *CLibraryDispatch::GetDictionary(void)
{
	return dictionary;
}

HRESULT CLibraryDispatch::doInvocation(DISPID dispIDMember, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR*  pDispParams, VARIANT FAR* pVarResult, EXCEPINFO FAR* pExcepInfo, unsigned int FAR* puArgErr)
{
	if (wFlags & DISPATCH_PROPERTYGET)
	{
		VariantInit(pVarResult);
		if (0 == dispIDMember)
		{
			pVarResult -> vt = VT_DISPATCH;
			pVarResult -> pdispVal = this;
			return ResultFromScode(S_OK);
		}
	}

	if (wFlags & DISPATCH_METHOD)
	{
		BindingNode *dll;
		dll = dictionary -> findDLL(dispIDMember);

		if (NULL != dll)
		{
			return doDLL(dll, dispIDMember, pDispParams, pVarResult, pExcepInfo, puArgErr);
		}
	}

	return ResultFromScode(DISP_E_MEMBERNOTFOUND);
}


HRESULT CLibraryDispatch::doDLL(BindingNode *node, DISPID dispIDMember, DISPPARAMS FAR*  pDispParams, VARIANT FAR* pVarResult, EXCEPINFO FAR* pExcepInfo, unsigned int FAR* puArgErr)
{
	unsigned int argCount = 0;
	Argument *runner;
	int intResult;
	float singleResult;
	double doubleResult;
	VARIANT variantResult;
	int *args = NULL;		// Args in stack form
	int nArgs = 0;
	int *argP;
	int k;
	VARIANT *vs;
	HRESULT err;

	/* Count the arguments */
	for (runner = node -> DLLfunc.args; runner; runner = runner -> next)
	{
		++argCount;
	}
	if (argCount != pDispParams -> cArgs)
	{
		*puArgErr = 0;
		pExcepInfo -> wCode = 1001;
		pExcepInfo -> wReserved = 0;
		pExcepInfo -> bstrSource = SysAllocString(L"NSBasic");
		pExcepInfo -> bstrDescription = SysAllocString(L"Incorrect number of arguments passed to a DLL call.");
		pExcepInfo -> bstrHelpFile = NULL;
		pExcepInfo -> pvReserved = NULL;
		pExcepInfo -> pfnDeferredFillIn = NULL;
		pExcepInfo -> scode = 0;

		return DISP_E_EXCEPTION;
	}

	/* Count the number of I4s needed */
	for (runner = node -> DLLfunc.args; runner; runner = runner -> next)
	{
		++nArgs;

		if (kArgDouble == runner -> argType || kArgDate == runner -> argType)
		{
			++nArgs;
		}
		else if (kArgVariant == runner -> argType && !runner -> byRef)
		{
			nArgs += sizeof(VARIANT) / 4 - 1;
		}
	}

	if (nArgs)
	{
		args = new int[nArgs];
		vs = new VARIANT[argCount];
		
		for (argP = args, k = 0, runner = node -> DLLfunc.args; runner; ++k, runner = runner -> next)
		{
			VariantInit(&(vs[k]));

			if (runner -> array)
			{
				SAFEARRAY *array = NULL;
				VariantCopyInd(&(vs[k]), &(pDispParams -> rgvarg[pDispParams -> cArgs - 1 - k]));

				if ((VT_ARRAY | VT_VARIANT) == vs[k].vt)
				{
					array = vs[k].parray;
				}
				else if ((VT_VARIANT | VT_BYREF) == vs[k].vt)
				{
					VARIANT *v;
					v = vs[k].pvarVal;
					if ((VT_VARIANT | VT_ARRAY) == v -> vt)
					{
						array = v -> parray;
					}
				}
				
				if (!array)
				{
					return DISP_E_BADVARTYPE;
				}

				long k;
				long nElements = 1;
				unsigned char *passedArray = NULL;

				for (k = 0; k < array -> cDims; ++k)
				{
					nElements *= array -> rgsabound[k].cElements/* DIKEOCE - array -> rgsabound[k].lLbound*/;
				}

				switch (runner -> argType)
				{
					case kArgBoolean:
						passedArray = new unsigned char[nElements * sizeof(bool)];
						break;
					case kArgByte:
						passedArray = new unsigned char[nElements];
						break;
					case kArgInteger:
						passedArray = new unsigned char[nElements * sizeof(short)];
						break;
					case kArgLong:
						passedArray = new unsigned char[nElements * sizeof(long)];
						break;
					case kArgString:
						passedArray = new unsigned char[nElements * sizeof(char *)];
						break;
					case kArgUString:
						passedArray = new unsigned char[nElements * sizeof(wchar_t *)];
						break;
					case kArgObject:
						passedArray = new unsigned char[nElements * sizeof(IDispatch *)];
						break;
					case kArgSingle:
						passedArray = new unsigned char[nElements * sizeof(float)];
						break;
					case kArgDouble:
						passedArray = new unsigned char[nElements * sizeof(double)];
						break;
					case kArgDate:
						passedArray = new unsigned char[nElements * sizeof(DATE)];
						break;
				}

				if (!passedArray)
				{
					return DISP_E_BADVARTYPE;
				}

				*argP++ = (int) passedArray;

				VARIANT *vp;
				vp = (VARIANT *)(array -> pvData);
				
				for (k = 0; k < nElements; ++k)
				{
					VARIANT v;
					VariantInit(&v);
					VariantCopyInd(&v,&(vp[k]));

					switch (runner -> argType)
					{
						case kArgBoolean:
							err = VariantChangeType(&v, &v, 0, VT_BOOL);
							if (FAILED(err))
							{
								delete passedArray;
								return DISP_E_BADVARTYPE;
							}
							((short *)passedArray)[k] = (short) v.boolVal;
							break;
						case kArgByte:
							err = VariantChangeType(&v, &v, 0, VT_UI1);
							if (FAILED(err))
							{
								delete passedArray;
								return DISP_E_BADVARTYPE;
							}
							((unsigned char *)passedArray)[k] = (unsigned char)v.pbVal;
							break;
						case kArgInteger:
							err = VariantChangeType(&v, &v, 0, VT_I2);
							if (FAILED(err))
							{
								delete passedArray;
								return DISP_E_BADVARTYPE;
							}
							((short *)passedArray)[k] = v.iVal;
							break;
						case kArgLong:
							err = VariantChangeType(&v, &v, 0, VT_I4);
							if (FAILED(err))
							{
								delete passedArray;
								return DISP_E_BADVARTYPE;
							}
							((long *)passedArray)[k] = v.lVal;
							break;
						case kArgString:
							err = VariantChangeType(&v, &v, 0, VT_BSTR);
							if (FAILED(err))
							{
								delete passedArray;
								return DISP_E_BADVARTYPE;
							}
							{
								USES_CONVERSION;
								char *s = W2A(v.bstrVal);
								((char **)passedArray)[k] = new char[strlen(s) + 1];
								strcpy(((char **)passedArray)[k], s);
							}
							break;
						case kArgUString:
							err = VariantChangeType(&v, &v, 0, VT_BSTR);
							if (FAILED(err))
							{
								delete passedArray;
								return DISP_E_BADVARTYPE;
							}
							((BSTR *)passedArray)[k] =  v.bstrVal;
							break;
						case kArgObject:
							err = VariantChangeType(&v, &v, 0, VT_DISPATCH);
							if (FAILED(err))
							{
								delete passedArray;
								return DISP_E_BADVARTYPE;
							}
							((IDispatch **)passedArray)[k] =  v.pdispVal;
							break;
						case kArgSingle:
							err = VariantChangeType(&v, &v, 0, VT_R4);
							if (FAILED(err))
							{
								delete passedArray;
								return DISP_E_BADVARTYPE;
							}
							((float *)passedArray)[k] =  v.fltVal;
							break;
						case kArgDouble:
							err = VariantChangeType(&v, &v, 0, VT_R8);
							if (FAILED(err))
							{
								delete passedArray;
								return DISP_E_BADVARTYPE;
							}
							((double *)passedArray)[k] =  v.dblVal;
							break;
						case kArgDate:
							err = VariantChangeType(&v, &v, 0, VT_DATE);
							if (FAILED(err))
							{
								delete passedArray;
								return DISP_E_BADVARTYPE;
							}
							((DATE *)passedArray)[k] =  v.date;
							break;
					}
				}
			}
			else
			{
				switch (runner -> argType)
				{
					case kArgVariant:
						if (runner -> byRef)
						{
							err = DispGetParam(pDispParams, k, VT_VARIANT | VT_BYREF, &(vs[k]), puArgErr);
							if (SUCCEEDED(err))
							{
								*argP++ = (int) &(vs[k]);
							}
							else
							{
								/* It's OK, can pass any variant by reference */
								*argP++ = (int) &(pDispParams -> rgvarg[pDispParams -> cArgs - k - 1]);
							}
						}
						else
						{
							err = DispGetParam(pDispParams, k, VT_VARIANT | VT_BYREF, &(vs[k]), puArgErr);
							if (SUCCEEDED(err))
							{
								memcpy(argP, &(vs[k]), sizeof(VARIANT));
								argP += sizeof(VARIANT);
							}
							else
							{
								/* It's OK, can pass any variant by value */
								memcpy(argP, &(pDispParams -> rgvarg[pDispParams -> cArgs - k - 1]), sizeof(VARIANT));
								argP += sizeof(VARIANT);
							}
						}
						break;
					case kArgBoolean:
						if (runner -> byRef)
						{
							vs[k] = pDispParams -> rgvarg[argCount - k - 1];
							if (vs[k].vt == (VT_BYREF | VT_VARIANT))
							{
								VARIANT *v = vs[k].pvarVal;
								err = VariantChangeType(v, v, 0, VT_BOOL);
								if (FAILED(err))
								{
									VariantInit(v);
									v -> vt = VT_BOOL;
									v -> boolVal = 0;
								}
								*argP++ = (int) &(v -> boolVal);
							}
							else
							{
								err = VariantChangeType(&(vs[k]), &(vs[k]), 0, VT_BOOL);
								if (FAILED(err)) return err;
								*argP++ = (int) &(vs[k].boolVal);
							}
						}
						else
						{
							err = DispGetParam(pDispParams, k, VT_BOOL, &(vs[k]), puArgErr);
							if (FAILED(err)) return err;
							*argP++ = (int) vs[k].boolVal;
						}
						break;
					case kArgByte:
						if (runner -> byRef)
						{
							vs[k] = pDispParams -> rgvarg[argCount - k - 1];
							if (vs[k].vt == (VT_BYREF | VT_VARIANT))
							{
								VARIANT *v = vs[k].pvarVal;
								err = VariantChangeType(v, v, 0, VT_UI1);
								if (FAILED(err))
								{
									VariantInit(v);
									v -> vt = VT_UI1;
									v -> bVal = 0;
								}
								*argP++ = (int) &(v -> bVal);
							}
							else
							{
								err = VariantChangeType(&(vs[k]), &(vs[k]), 0, VT_UI1);
								if (FAILED(err)) return err;
								*argP++ = (int) &(vs[k].bVal);
							}
						}
						else
						{
							err = DispGetParam(pDispParams, k, VT_UI1, &(vs[k]), puArgErr);
							if (FAILED(err)) return err;
							*argP++ = (int) vs[k].bVal;
						}
						break;
					case kArgInteger:
						if (runner -> byRef)
						{
							vs[k] = pDispParams -> rgvarg[argCount - k - 1];
							if (vs[k].vt == (VT_BYREF | VT_VARIANT))
							{
								VARIANT *v = vs[k].pvarVal;
								err = VariantChangeType(v, v, 0, VT_I2);
								if (FAILED(err))
								{
									VariantInit(v);
									v -> vt = VT_I2;
									v -> iVal = 0;
								}
								*argP++ = (int) &(v -> iVal);
							}
							else
							{
								err = VariantChangeType(&(vs[k]), &(vs[k]), 0, VT_I2);
								if (FAILED(err)) return err;
								*argP++ = (int) &(vs[k].iVal);
							}
						}
						else
						{
							err = DispGetParam(pDispParams, k, VT_I2, &(vs[k]), puArgErr);
							if (FAILED(err)) return err;
							*argP++ = (int) vs[k].iVal;
						}
						break;
					case kArgLong:
						if (runner -> byRef)
						{
							vs[k] = pDispParams -> rgvarg[argCount - k - 1];
							if (vs[k].vt == (VT_BYREF | VT_VARIANT))
							{
								VARIANT *v = vs[k].pvarVal;
								err = VariantChangeType(v, v, 0, VT_I4);
								if (FAILED(err))
								{
									VariantInit(v);
									v -> vt = VT_I4;
									v -> lVal = 0;
								}
								*argP++ = (int) &(v -> lVal);
							}
							else
							{
								err = VariantChangeType(&(vs[k]), &(vs[k]), 0, VT_I4);
								if (FAILED(err)) return err;
								*argP++ = (int) &(vs[k].lVal);
							}
						}
						else
						{
							err = DispGetParam(pDispParams, k, VT_I4, &(vs[k]), puArgErr);
							if (FAILED(err)) return err;
							*argP++ = (int) vs[k].lVal;
						}
						break;
					case kArgString:
						if (runner -> byRef)
						{
							*puArgErr = 0;
							pExcepInfo -> wCode = 1001;
							pExcepInfo -> wReserved = 0;
							pExcepInfo -> bstrSource = SysAllocString(L"NSBasic");
							pExcepInfo -> bstrDescription = SysAllocString(L"Cannot pass a string by reference");
							pExcepInfo -> bstrHelpFile = NULL;
							pExcepInfo -> pvReserved = NULL;
							pExcepInfo -> pfnDeferredFillIn = NULL;
							pExcepInfo -> scode = 0;

							return DISP_E_EXCEPTION;
						}
						else
						{
							USES_CONVERSION;
							err = DispGetParam(pDispParams, k, VT_BSTR, &(vs[k]), puArgErr);
							if (FAILED(err)) return err;
							*argP++ = (int) W2A(vs[k].bstrVal);
						}
						break;
					case kArgUString:
						if (runner -> byRef)
						{
							err = DispGetParam(pDispParams, k, VT_BYREF | VT_BSTR, &(vs[k]), puArgErr);
							if (FAILED(err)) return err;
							*argP++ = (int) vs[k].pbstrVal;
						}
						else
						{
							vs[k] = pDispParams -> rgvarg[argCount - k - 1];

							if (vs[k].vt == (VT_BYREF | VT_VARIANT))
							{
								vs[k] = *vs[k].pvarVal;
							}

							if (vs[k].vt == VT_BSTR)
							{
							}
							else
							{
								err = DispGetParam(pDispParams, k, VT_BSTR, &(vs[k]), puArgErr);
								if (FAILED(err)) return err;
							}
							*argP++ = (int) vs[k].bstrVal;
						}
						break;
					case kArgObject:
						if (runner -> byRef)
						{
							vs[k] = pDispParams -> rgvarg[argCount - k - 1];
							if (vs[k].vt == (VT_BYREF | VT_VARIANT))
							{
								VARIANT *v = vs[k].pvarVal;
								err = VariantChangeType(v, v, 0, VT_DISPATCH);
								if (FAILED(err))
								{
									VariantInit(v);
									v -> vt = VT_DISPATCH;
									v -> pdispVal = 0;
								}
								*argP++ = (int) &(v -> pdispVal);
							}
							else
							{
								err = VariantChangeType(&(vs[k]), &(vs[k]), 0, VT_DISPATCH);
								if (FAILED(err)) return err;
								*argP++ = (int) &(vs[k].pdispVal);
							}
						}
						else
						{
							err = DispGetParam(pDispParams, k, VT_DISPATCH, &(vs[k]), puArgErr);
							if (FAILED(err)) return err;
							*argP++ = (int) vs[k].pdispVal;
						}
						break;
					case kArgSingle:
						if (runner -> byRef)
						{
							vs[k] = pDispParams -> rgvarg[argCount - k - 1];
							if (vs[k].vt == (VT_BYREF | VT_VARIANT))
							{
								VARIANT *v = vs[k].pvarVal;
								err = VariantChangeType(v, v, 0, VT_R4);
								if (FAILED(err))
								{
									VariantInit(v);
									v -> vt = VT_R4;
									v -> fltVal = 0.0;
								}
								*argP++ = (int) &(v -> fltVal);
							}
							else
							{
								err = VariantChangeType(&(vs[k]), &(vs[k]), 0, VT_R4);
								if (FAILED(err)) return err;
								*argP++ = (int) &(vs[k].fltVal);
							}
						}
						else
						{
							err = DispGetParam(pDispParams, k, VT_R4, &(vs[k]), puArgErr);
							if (FAILED(err)) return err;
							*argP++ = (int) vs[k].fltVal;
						}
						break;
					case kArgDouble:
						if (runner -> byRef)
						{
							vs[k] = pDispParams -> rgvarg[argCount - k - 1];
							if (vs[k].vt == (VT_BYREF | VT_VARIANT))
							{
								VARIANT *v = vs[k].pvarVal;
								err = VariantChangeType(v, v, 0, VT_R8);
								if (FAILED(err))
								{
									VariantInit(v);
									v -> vt = VT_R8;
									v -> dblVal = 0.0L;
								}
								*argP++ = (int) &(v -> dblVal);
							}
							else
							{
								err = VariantChangeType(&(vs[k]), &(vs[k]), 0, VT_R8);
								if (FAILED(err)) return err;
								*argP++ = (int) &(vs[k].dblVal);
							}
						}
						else
						{
							union
							{
								double d;
								struct
								{
									int i1;
									int i2;
								} i;
							} u;

							err = DispGetParam(pDispParams, k, VT_R8, &(vs[k]), puArgErr);
							if (FAILED(err)) return err;
							u.d = vs[k].dblVal;
							*argP++ = u.i.i1;
							*argP++ = u.i.i2;
						}
						break;
					case kArgDate:
						if (runner -> byRef)
						{
							vs[k] = pDispParams -> rgvarg[argCount - k - 1];
							if (vs[k].vt == (VT_BYREF | VT_VARIANT))
							{
								VARIANT *v = vs[k].pvarVal;
								err = VariantChangeType(v, v, 0, VT_DATE);
								if (FAILED(err))
								{
									VariantInit(v);
									v -> vt = VT_DATE;
									v -> dblVal = 0.0L;
								}
								*argP++ = (int) &(v -> dblVal);
							}
							else
							{
								err = VariantChangeType(&(vs[k]), &(vs[k]), 0, VT_DATE);
								if (FAILED(err)) return err;
								*argP++ = (int) &(vs[k].dblVal);
							}
						}
						else
						{
							union
							{
								double d;
								struct
								{
									int i1;
									int i2;
								} i;
							} u;

							err = DispGetParam(pDispParams, k, VT_DATE, &(vs[k]), puArgErr);
							if (FAILED(err)) return err;
							u.d = vs[k].dblVal;
							*argP++ = u.i.i1;
							*argP++ = u.i.i2;
						}
						break;
				}
			}
		}
	}

	/* Call the function */
	const wchar_t *uName;
	uName = dictionary -> getSymbolName(dispIDMember);

	void *func;
	func = GetProcAddress(library, uName);
	if (!func)
	{
		wchar_t buf[200];	// DIKEOCE
		wsprintf(buf, L"Function or procedure %s is not present in DLL", uName);
		*puArgErr = 0;
		pExcepInfo -> wCode = 1001;
		pExcepInfo -> wReserved = 0;
		pExcepInfo -> bstrSource = SysAllocString(L"NSBasic");
		pExcepInfo -> bstrDescription = SysAllocString(buf);
		pExcepInfo -> bstrHelpFile = NULL;
		pExcepInfo -> pvReserved = NULL;
		pExcepInfo -> pfnDeferredFillIn = NULL;
		pExcepInfo -> scode = 0;

		return DISP_E_EXCEPTION;
	}

	switch (node -> DLLfunc.retType)
	{
		case kArgNone:
		case kArgBoolean:
		case kArgInteger:
		case kArgByte:
		case kArgLong:
		case kArgString:
		case kArgUString:
		case kArgObject:
			intResult = callInt(func, nArgs, args);
			break;
		case kArgSingle:
			singleResult = callFloat(func, nArgs, args);
			break;
		case kArgDouble:
		case kArgDate:
			doubleResult = callDouble(func, nArgs, args);
			break;
		case kArgVariant:
			variantResult = callVariant(func, nArgs, args);
			break;
	}
	USES_CONVERSION;

	/* Return the value */
	if (pVarResult)
	{
		VariantInit(pVarResult);

		switch (node -> DLLfunc.retType)
		{
			case kArgNone:
				break;
			case kArgByte:
				pVarResult -> vt = VT_UI1;
				pVarResult -> bVal = intResult;
				break;
			case kArgInteger:
				pVarResult -> vt = VT_I2;
				pVarResult -> iVal = intResult;
				break;
			case kArgBoolean:
				pVarResult -> vt = VT_BOOL;
				pVarResult -> boolVal = intResult;
				break;
			case kArgLong:
				pVarResult -> vt = VT_I4;
				pVarResult -> lVal = intResult;
				break;
			case kArgString:
				pVarResult -> vt = VT_BSTR;
				pVarResult -> bstrVal = SysAllocString(A2W((char *) intResult));
				break;
			case kArgUString:
				pVarResult -> vt = VT_BSTR;
				pVarResult -> bstrVal = (BSTR) intResult;
				break;
			case kArgObject:
				pVarResult -> vt = VT_DISPATCH;
				pVarResult -> pdispVal = (IDispatch *) intResult;
				break;
			case kArgSingle:
				pVarResult -> vt = VT_R4;
				pVarResult -> fltVal = singleResult;
				break;
			case kArgDouble:
			case kArgDate:
				pVarResult -> vt = VT_R8;
				pVarResult -> dblVal = doubleResult;
				break;
			case kArgVariant:
				VariantCopyInd(pVarResult, &variantResult);
				break;
		}
	}

	if (nArgs)
	{		
		for (argP = args, k = 0, runner = node -> DLLfunc.args; runner; ++k, runner = runner -> next)
		{
			if (runner -> array)
			{
				if (runner -> byRef) // DIKEOCE
				{
					if ((VT_VARIANT | VT_BYREF) == pDispParams -> rgvarg[pDispParams -> cArgs - 1 - k].vt)
					{
						/* It's safe to construct a new array */
						VARIANT *v;
						SAFEARRAY *oldArray = NULL;

						if ((VT_ARRAY | VT_VARIANT) == vs[k].vt)
						{
							oldArray = vs[k].parray;
						}
						else if ((VT_VARIANT | VT_BYREF) == vs[k].vt)
						{
							VARIANT *v;
							v = vs[k].pvarVal;
							if ((VT_VARIANT | VT_ARRAY) == v -> vt)
							{
								oldArray = v -> parray;
							}
						}

						if (oldArray)
						{
							int nElements = 1;
							long d;

							for (d = 0; d < oldArray -> cDims; ++d)
							{
								nElements *= oldArray -> rgsabound[d].cElements /*DIKEOCE - oldArray -> rgsabound[d].lLbound*/;
							}

							/* Store the array */
							v = pDispParams -> rgvarg[pDispParams -> cArgs - 1 - k].pvarVal;
							if ((VT_VARIANT | VT_ARRAY | VT_BYREF) == v -> vt)
							{
								int i;

								SAFEARRAY *newArray;
								VARIANT *variants;
								void *passedArray = (void *)(*argP);

								newArray = *(v ->pparray);

								variants = (VARIANT *)newArray -> pvData;
								for (i = 0; i < nElements; ++i)
								{
									VARIANT *v = &variants[i];
									VariantClear(&variants[i]);
									VariantInit(&variants[i]);
									
									switch (runner -> argType)
									{
										case kArgBoolean:
											v -> vt = VT_BOOL;
											v -> boolVal = ((short *)passedArray)[i];
											break;
										case kArgByte:
											v -> vt = VT_UI1;
											v -> bVal = ((unsigned char *)passedArray)[i];
											break;
										case kArgInteger:
											v -> vt = VT_I2;
											v -> iVal = ((short *)passedArray)[i];
											break;
										case kArgLong:
											v -> vt = VT_I4;
											v -> lVal = ((long *)passedArray)[i];
											break;
										case kArgString:
											v -> vt = VT_BSTR;
											{
												USES_CONVERSION;
												v -> bstrVal = A2BSTR(((char **)passedArray)[i]);
												delete (((char **)passedArray)[i]);
											}
											break;
										case kArgUString:
											v -> vt = VT_BSTR;
											v -> bstrVal = ((BSTR *)passedArray)[i];
											break;
										case kArgObject:
											v -> vt = VT_DISPATCH;
											v -> pdispVal = ((IDispatch **)passedArray)[i];
											break;
										case kArgSingle:
											v -> vt = VT_R4;
											v -> fltVal = ((float *)passedArray)[i];
											break;
										case kArgDouble:
											v -> vt = VT_R8;
											v -> dblVal = ((double *)passedArray)[i];
											break;
										case kArgDate:
											v -> vt = VT_DATE;
											v -> date = ((DATE *)passedArray)[i];
											break;
									}
								}
							}
						}
					}
				}
				VariantClear(&(vs[k]));		// DIKEOCE

				delete (unsigned int *)*argP;
				++argP;
			}
			else
			{
				switch (runner -> argType)
				{
					case kArgVariant:
						if (runner -> byRef)
						{
							++argP;
						}
						else
						{
							argP += sizeof(VARIANT);
						}
						break;
					case kArgBoolean:
						++argP;
						break;
					case kArgByte:
						++argP;
						break;
					case kArgInteger:
						++argP;
						break;
					case kArgLong:
						++argP;
						break;
					case kArgString:
						++argP;
						break;
					case kArgUString:
						++argP;
						break;
					case kArgObject:
						++argP;
						break;
					case kArgSingle:
						++argP;
						break;
					case kArgDouble:
						if (runner -> byRef)
						{
							++argP;
						}
						else
						{
							++argP;
							++argP;
						}
						break;
					case kArgDate:
						if (runner -> byRef)
						{
							++argP;
						}
						else
						{
							++argP;
							++argP;
						}
						break;
				}
			}
		}
		delete args;
		delete vs;
	}

	return ResultFromScode(S_OK);
}


/////////////////////////////////////////////////////////////////////////////
// CScriptEngine

IMPLEMENT_DYNCREATE(CScriptEngine, CCmdTarget)

CScriptEngine::CScriptEngine()
{
	int i;

	EnableAutomation();

	m_hWnd=NULL;
	m_pcWnd=0;
	tokenType = kTTEOF;

	m_scriptpreamble.LoadString(IDS_PREAMBLE);
	m_pcstrDebugScript=0;

	m_pScript = NULL;
	m_pParse = NULL;
	
	m_GuidLookup.RemoveAll();
	//m_GuidLookup.SetAt(TEXT("ado"),TEXT("adoce.recordset"));
#if _WIN32_WCE < 300
	m_GuidLookup.SetAt(TEXT("ado"),			TEXT("{4BEB93D3-28D8-11D1-8321-00A024A88110}"));
#else
	m_GuidLookup.SetAt(TEXT("ado"),			TEXT("{113033F8-F682-11D2-BB62-00C04F680ACC}"));
#endif
	//m_GuidLookup.SetAt(TEXT("comm"),TEXT("cecomm.comm"));
	m_GuidLookup.SetAt(TEXT("comm"),		TEXT("{481BA4B1-56F2-11D1-A1AB-00C04FA87A04}"));
	//m_GuidLookup.SetAt(TEXT("dialog"),TEXT("cecomdlg.commondialog.1"));
	m_GuidLookup.SetAt(TEXT("dialog"),		TEXT("cecomdlg.commondialog.1"));
   m_GuidLookup.SetAt( _T( "dialogx" ), _T( "NSBASIC.DialogX.1" ) );
	//m_GuidLookup.SetAt(TEXT("file"),TEXT("filectl.file"));
	m_GuidLookup.SetAt(TEXT("file"),		TEXT("{25C953B5-5464-11D1-A714-00AA0044064C}"));
	//m_GuidLookup.SetAt(TEXT("filesystem"),TEXT("filectl.filesystem"));
	m_GuidLookup.SetAt(TEXT("filesystem"),	TEXT("{3F0C2794-5C3A-11D1-A717-00AA0044064C}"));
	//m_GuidLookup.SetAt(TEXT("finance"),TEXT("pVBFinFunc.pVBFinFunc"));
	m_GuidLookup.SetAt(TEXT("finance"),		TEXT("{97A3DC81-CBAC-11D0-A11F-08005AB89658}"));
	m_GuidLookup.SetAt(TEXT("grid"),TEXT("gridctrl.gridctrl.1"));
	//m_GuidLookup.SetAt(TEXT("grid"),		TEXT("{532C2C02-6B55-11D1-9AA5-00C04FAD5AEC}"));
	//m_GuidLookup.SetAt(TEXT("picturebox"),TEXT("picturebox.picturebox.1"));
	//m_GuidLookup.SetAt(TEXT("picturebox"),	TEXT("{338D5EB3-4BBD-11D1-9A7D-00C04FAD5AEC}"));
	m_GuidLookup.SetAt(TEXT("picturebox"),	IID_IPictureBoxTxt);
	m_GuidLookup.SetAt(TEXT("winsock"),TEXT("winsock.winsock.1"));
	//m_GuidLookup.SetAt(TEXT("winsock"),		TEXT("{23CE4D03-25A1-11D1-9A72-00A0C986B84A}"));
	m_GuidLookup.SetAt(TEXT("vbcemiscutil"),TEXT("{14CAE510-DC57-11D1-B34C-B20BAD11A827}"));
	//m_GuidLookup.SetAt(TEXT("grid"),		TEXT("{532C2C02-6B55-11D1-9AA5-00C04FAD5AEC}"));
	m_GuidLookup.SetAt(TEXT("image"),		TEXT("image.imagectl.1"));
	m_GuidLookup.SetAt(TEXT("imagelist"),	TEXT("ceimagelist.imagelistctrl.1"));
	m_GuidLookup.SetAt(TEXT("listview"),	TEXT("listviewctrl.listviewctrl.1"));
	m_GuidLookup.SetAt(TEXT("tabstrip"),	TEXT("cetabstrip.tabstrip.1"));
	m_GuidLookup.SetAt(TEXT("treeview"),	TEXT("treeviewctl.treeviewctl.1"));


	m_IntrinsicLookup.RemoveAll();
	for(i=0;i<(sizeof(gaIntrinsicObjects)/sizeof(IntrinsicObject));i++)
	{
		if (0 == wcscmp(L"optionbutton", gaIntrinsicObjects[i].szShortName))
		{
			OSVERSIONINFO versionInfo;
			versionInfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
			if (!GetVersionEx(&versionInfo))
			{
				versionInfo.dwMajorVersion = 2;
			}
			if (versionInfo.dwMajorVersion >= 5)
			{
				gaIntrinsicObjects[i].dwStyle |= BS_RADIOBUTTON;
			}
			else
			{
				gaIntrinsicObjects[i].dwStyle |= BS_AUTORADIOBUTTON | WS_GROUP;
			}
		}
		m_IntrinsicLookup.SetAt(gaIntrinsicObjects[i].szShortName,&gaIntrinsicObjects[i]);
	}

//	m_bAutoDelete = TRUE;		// default to auto-delete
//	m_dwRegister = 0;				// not registered as active by default

	// create an IUnknown
	EnableAggregation();

	// allow event connections
	EnableConnections();

	// turn on type library support
	EnableTypeLib();


}

CScriptEngine::~CScriptEngine()
{
	// Close the ActiveX Script Engine

	ReleaseScriptEngine();
}

void CScriptEngine::OnFinalRelease()
{
	// When the last reference for an automation object is released
	// OnFinalRelease is called.  The base class will automatically
	// deletes the object.  Add additional cleanup required for your
	// object before calling the base class.

	CCmdTarget::OnFinalRelease();
}

BOOLEAN CScriptEngine::InitScriptEngine()
{//resets the script engine

	HRESULT hr;
	
	hr=ReleaseScriptEngine();
	if(!SUCCEEDED(hr))
		{
			TCHAR szErr[50];
			wsprintf(szErr,L"Failed to release engine with err %lx",hr);
			::MessageBox(m_hWnd,szErr,L"FATAL ERROR",MB_OK);
			return false;
		}

	//::MessageBox(m_hWnd,L"RELEASED",L"",MB_OK);

	hr=CreateScriptEngine();
	if(!SUCCEEDED(hr))
		{
			TCHAR szErr[50];
			wsprintf(szErr,L"Failed to create engine with err %lx",hr);
			::MessageBox(m_hWnd,szErr,L"FATAL ERROR",MB_OK);
			return false;
		}

	return true;
}

HRESULT CScriptEngine::ReleaseScriptEngine()
{
	// Close the ActiveX Script Engine
	HRESULT hr;

	if (m_ddScript.m_lpDispatch)
	{
		DebugRefCount(m_ddScript.m_lpDispatch,L"LPDispatch prior to release");
		m_ddScript.ReleaseDispatch();
		m_ddScript.m_lpDispatch=0;
	}

	if (m_pScript)
	{
		//EXCEPINFO exception;

		//::MessageBox(m_hWnd,L"DISCONNECTING pScript",L"",MB_OK);
		//::MessageBox(m_hWnd,L"CLOSING pScript",L"",MB_OK);
		//this causes a hang!
		/*hr=m_pScript->Close();
		if(!SUCCEEDED(hr))
		{
			TCHAR szErr[50];
			wsprintf(szErr,L"Failed to close with err %lx",hr);
			::MessageBox(m_hWnd,szErr,L"STATUS",MB_OK);
		}*/
		//::MessageBox(m_hWnd,L"INTERRUPTING pScript",L"",MB_OK);
		
		/*hr=m_pScript->InterruptScriptThread(SCRIPTTHREADID_CURRENT  ,&exception,0 );
		if(!SUCCEEDED(hr))
		{
			TCHAR szErr[50];
			wsprintf(szErr,L"Failed to interrupt thread with err %lx",hr);
			::MessageBox(m_hWnd,szErr,L"STATUS",MB_OK);
		}*/

/*			hr=m_pScript->Close();
			if(!SUCCEEDED(hr))
			{
				TCHAR szErr[50];
				wsprintf(szErr,L"Failed to close with err %lx",hr);
				::MessageBox(m_hWnd,szErr,L"STATUS",MB_OK);
			}
*/		
		
		hr=m_pScript->SetScriptState(SCRIPTSTATE_INITIALIZED);
		if(!SUCCEEDED(hr))
		{
			TCHAR szErr[50];
			wsprintf(szErr,L"Failed to set state to initialized with err %lx",hr);
			::MessageBox(m_hWnd,szErr,L"FATAL ERROR",MB_OK);
		}
		//::MessageBox(m_hWnd,L"RELEASING pScript",L"",MB_OK);
		DebugRefCount(m_pScript,L"m_pScript prior to release");
		hr=m_pScript->Release();

		m_pScript = NULL;
	}

	//::MessageBox(m_hWnd,L"RELEASING pParse",L"",MB_OK);
	if (m_pParse)
	{
		DebugRefCount(m_pParse,L"m_pParse prior to release");

		hr=m_pParse->Release();
		m_pParse = NULL;
	}

	//used to remove dispatch pointer here
	m_objects.RemoveAll();

	//::MessageBox(m_hWnd,L"REMOVEALL CALLED",L"STATUS",MB_OK);

	return S_OK;

}

HRESULT CScriptEngine::CreateScriptEngine()
{
	HRESULT hr;
	//IUnknown* p;
	CLSID clsid;

	if (m_pScript)
		return S_FALSE;	// can't create it more than once!

	hr = CLSIDFromProgID( OLESTR("VBScript"), &clsid );
	
	//Get an instance of the VBScript object..
	//hr=CLSIDFromString((SCRIPTING_ENGINE_GUID),&clsid);
	if (!SUCCEEDED(hr))
	{
		hr = CLSIDFromProgID( OLESTR("VBS"), &clsid );
		if (!SUCCEEDED(hr))
		{
			::MessageBox(m_hWnd,L"Could not find CLSID for VBScript",L"NSB FATAL ERROR",MB_OK);
			TRACE(TEXT("Could not find class ID for VBScript\n"));
			return hr;
		}
	}

	hr = CoCreateInstance( clsid, 
							NULL, 
							CLSCTX_INPROC_SERVER, //was CLSCTX_INPROC_SERVER
							IID_IActiveScript, 
							(void **)&m_pScript);

	if (!SUCCEEDED(hr))
	{
		TCHAR szErr[50];
		wsprintf(szErr,L"Failed to create engine '%s' with err %lx",clsid,hr);
		::MessageBox(m_hWnd,szErr,L"NSB FATAL ERROR",MB_OK);
		TRACE(TEXT("Error Creating VBScript Engine\n"));
		return hr;
	}

	DebugRefCount(m_pScript,L"m_pScript/CreateScriptEngine");
	
	//Form object is {AF7E5CB7-BE9B-11D0-8B24-0000F803A3DB}

	// Script Engine must support IActiveScriptParse for us to use it
	hr = m_pScript->QueryInterface(IID_IActiveScriptParse, (void **)&m_pParse);
	if (!SUCCEEDED(hr))
	{
		TRACE(TEXT("ERROR: This script engine needs to support IActiveScriptParse\n"));
		return hr;
	}

	DebugRefCount(m_pParse,L"m_pParse after QI/CreateScriptEngine");


	hr = m_pScript->SetScriptSite(&m_xActiveScriptSite);
	if (!SUCCEEDED(hr))
	{
		TRACE(TEXT("Error setting VBScript Engine site\n"));
		return hr;
	}

	//::MessageBox(m_hWnd,L"About to InitNew",L"STATUS",MB_OK);
	// InitNew the object
	hr = m_pParse->InitNew();
	if (!SUCCEEDED(hr))
	{
		TCHAR szErr[50];
		wsprintf(szErr,L"Failed to InitNew with err %lx",hr);
		::MessageBox(m_hWnd,szErr,L"FATAL ERROR",MB_OK);
		TRACE(TEXT("Error Creating VBScript Engine\n"));
		return hr;
	}
	//::MessageBox(m_hWnd,L"InitNew Succeeded",L"STATUS",MB_OK);

	//add our scripting object to the script namespace.  
	hr = m_pScript->AddNamedItem(kScriptEngineObjectName, SCRIPTITEM_ISVISIBLE | SCRIPTITEM_ISSOURCE | SCRIPTITEM_GLOBALMEMBERS);

	
	//Add the CECOMM control as "comm" - don't care if it fails.
	//AddControl(TEXT("{481BA4B1-56F2-11D1-A1AB-00C04FA87A04}"),kCommObjectName,0,0,5,5);
	//moved the CECOMM control add to later so it's added to the output window as a control..


	return hr;
}


//	this code associates our type library with our class
IMPLEMENT_OLETYPELIB(CScriptEngine, DIID_IScriptEngine, 1, 0)

BEGIN_MESSAGE_MAP(CScriptEngine, CCmdTarget)
	//{{AFX_MSG_MAP(CScriptEngine)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/* EMP This is annoying, but have to change the dispatch map to allow DLL dispatches. */
#undef BEGIN_DISPATCH_MAP

#define BEGIN_DISPATCH_MAP(theClass, baseClass) \
	const AFX_DISPMAP* PASCAL theClass::_GetBaseDispatchMap() \
		{ return &baseClass::dispatchMap; } \
	const AFX_DISPMAP* theClass::GetDispatchMap() const \
		{ return &theClass::dispatchMap; } \
	AFX_COMDAT const AFX_DISPMAP theClass::dispatchMap = \
		{ &theClass::_GetBaseDispatchMap, &theClass::_dispatchEntries[0], \
			&theClass::_dispatchEntryCount, &theClass::_dwStockPropMask }; \
	AFX_COMDAT UINT theClass::_dispatchEntryCount = (UINT)-1; \
	AFX_COMDAT DWORD theClass::_dwStockPropMask = (DWORD)-1; \
	AFX_COMDAT const AFX_DISPMAP_ENTRY theClass::_dispatchEntries[] = \
	{ \


BEGIN_DISPATCH_MAP(CScriptEngine, CCmdTarget)
	//{{AFX_DISPATCH_MAP(CScriptEngine)
	DISP_PROPERTY_EX(CScriptEngine, "KeyPreview", GetKeyPreview, SetKeyPreview, VT_BOOL)
	DISP_PROPERTY_EX(CScriptEngine, "KeyboardStatus", GetKeyboardStatus, SetKeyboardStatus, VT_BOOL)
	DISP_PROPERTY_EX(CScriptEngine, "CurrentPath", GetCurrentPath, SetCurrentPath, VT_BSTR)
	DISP_PROPERTY_EX(CScriptEngine, "AppTitle", GetTitle, SetTitle, VT_BSTR)
	DISP_PROPERTY_EX(CScriptEngine, "NSBVersion", GetNSBVersion, SetNSBVersion, VT_BSTR)
	DISP_PROPERTY_EX(CScriptEngine, "LastHWND", GetLastHWND, SetNotSupported, VT_I4)
	DISP_PROPERTY_EX(CScriptEngine, "CommandLine", xGetCommandLine, SetNotSupported, VT_BSTR)
	DISP_PROPERTY_EX(CScriptEngine, "WaveVolume", GetWaveVolume, SetWaveVolume, VT_I4)
	DISP_PROPERTY_EX(CScriptEngine, "AppHWnd", GetAppHWnd, SetNotSupported, VT_I4)
	DISP_PROPERTY_EX(CScriptEngine, "QueryUnloadCancel", GetQueryUnloadCancel, SetQueryUnloadCancel, VT_BOOL)
	DISP_FUNCTION(CScriptEngine, "AddControl", AddControl, VT_BOOL, VTS_BSTR VTS_BSTR VTS_I2 VTS_I2 VTS_I2 VTS_I2)
	DISP_FUNCTION(CScriptEngine, "execute", execute, VT_EMPTY, VTS_BSTR)
	DISP_FUNCTION(CScriptEngine, "nsexecute", execute, VT_EMPTY, VTS_BSTR)
	DISP_FUNCTION(CScriptEngine, "eval", eval, VT_VARIANT, VTS_BSTR)
	DISP_FUNCTION(CScriptEngine, "print", print, VT_EMPTY, VTS_VARIANT VTS_VARIANT VTS_VARIANT VTS_VARIANT VTS_VARIANT VTS_VARIANT VTS_VARIANT VTS_VARIANT VTS_VARIANT VTS_VARIANT VTS_VARIANT VTS_VARIANT VTS_VARIANT VTS_VARIANT VTS_VARIANT VTS_VARIANT VTS_VARIANT VTS_VARIANT VTS_VARIANT VTS_VARIANT )
	DISP_FUNCTION(CScriptEngine, "MessageBox", MsgBox, VT_I4, VTS_VARIANT VTS_VARIANT VTS_VARIANT )
	DISP_FUNCTION(CScriptEngine, "AddObject", AddObject, VT_UNKNOWN, VTS_BSTR VTS_VARIANT VTS_VARIANT VTS_VARIANT VTS_VARIANT VTS_VARIANT VTS_VARIANT)
	DISP_FUNCTION(CScriptEngine, "bye", bye, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CScriptEngine, "sleep", sleep, VT_EMPTY, VTS_I4)
	DISP_FUNCTION(CScriptEngine, "UpdateScreen", UpdateScreen, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CScriptEngine, "SetMenu", SetMenu, VT_EMPTY, VTS_BSTR VTS_VARIANT)
	DISP_FUNCTION(CScriptEngine, "chain", chain, VT_EMPTY, VTS_BSTR VTS_VARIANT)
	DISP_FUNCTION(CScriptEngine, "Break", Break, VT_EMPTY, VTS_VARIANT VTS_VARIANT)
	DISP_FUNCTION(CScriptEngine, "KillFocus", KillFocus, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CScriptEngine, "WaitCursor", WaitCursor, VT_EMPTY, VTS_BOOL)
	DISP_FUNCTION(CScriptEngine, "InputBox", InputBox, VT_I2, VTS_BSTR)
	DISP_FUNCTION(CScriptEngine, "ShellExecute", ShellExecute, VT_I4, VTS_BSTR VTS_BSTR VTS_VARIANT)
	DISP_FUNCTION(CScriptEngine, "eval2", eval2, VT_I4, VTS_BSTR VTS_PVARIANT)
	DISP_FUNCTION(CScriptEngine, "PlaySound", xPlaySound, VT_BOOL, VTS_BSTR VTS_HANDLE VTS_I4)
	DISP_FUNCTION(CScriptEngine, "ShowOKButton", ShowOKButton, VT_EMPTY, VTS_BOOL)
	DISP_FUNCTION(CScriptEngine, "GetHWND", GetHWND, VT_I4, VTS_UNKNOWN)
	DISP_FUNCTION(CScriptEngine, "SetParent", xSetParent, VT_BOOL, VTS_UNKNOWN VTS_UNKNOWN)
	DISP_FUNCTION(CScriptEngine, "DoEvents", DoEvents, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CScriptEngine, "SendKey", doSendKey, VT_EMPTY, VTS_I2 VTS_I2)
	DISP_FUNCTION(CScriptEngine, "ShowFullScreen", ShowFullScreen, VT_BOOL, VTS_I4)
	DISP_FUNCTION(CScriptEngine, "RunAppAtTime", RunAppAtTime, VT_BOOL, VTS_BSTR VTS_I2 VTS_I2 VTS_I2 VTS_I2 VTS_I2 VTS_I2)
	DISP_FUNCTION(CScriptEngine, "RunAppAtEvent", RunAppAtEvent, VT_BOOL, VTS_BSTR VTS_I4)
	DISP_FUNCTION(CScriptEngine, "GetCommandLine", GetCommandLine, VT_BSTR, VTS_NONE)
	DISP_FUNCTION(CScriptEngine, "Declare", DoDeclare, VT_EMPTY, VTS_BSTR)
	DISP_FUNCTION(CScriptEngine, "GetSerialNumber", GetSerialNumber, VT_BSTR, VTS_NONE)
	DISP_FUNCTION(CScriptEngine, "Testomatic", Testomatic, VT_EMPTY, VTS_I4)
	DISP_FUNCTION(CScriptEngine, "SpecialFolder", SpecialFolder, VT_BSTR, VTS_I4 VTS_VARIANT)
	DISP_FUNCTION(CScriptEngine, "SendMessage", xSendMessage, VT_I4, VTS_I4 VTS_I4 VTS_I4 VTS_I4)
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Note: we add support for IID_IScriptEngine to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {6CA5B121-1609-11D2-852F-F26A3B000000}
static const IID IID_IScriptEngine =
{ 0x6ca5b121, 0x1609, 0x11d2, { 0x85, 0x2f, 0xf2, 0x6a, 0x3b, 0x0, 0x0, 0x0 } };

BEGIN_INTERFACE_MAP(CScriptEngine, CCmdTarget)
	INTERFACE_PART(CScriptEngine, IID_IScriptEngine, Dispatch)
	INTERFACE_PART(CScriptEngine, IID_IActiveScriptSite, ActiveScriptSite)
	INTERFACE_PART(CScriptEngine, IID_IActiveScriptSiteWindow, ActiveScriptSiteWindow)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CScriptEngine message handlers

//---------------------------------------------------------------------------
// IActiveScriptSite methods
//---------------------------------------------------------------------------
/**************************************************************************
* IMPLEMENT_IUNKNOWN
*
* This macro is defined in stdafx.h.  Implements QueryInterface, AddRef, and 
* Release (the IUnknown methods).
**************************************************************************/
IMPLEMENT_IUNKNOWN(CScriptEngine, ActiveScriptSite)

/**************************************************************************
* GetLCID
*
* Retrieves the locale identifier associated with the host's user interface. 
* The scripting engine uses the identifier to ensure that error strings and 
* other user-interface elements surfaced by the engine appear in the appropriate 
* language. If this method returns E_NOTIMPL, the system-defined locale identifier 
* should be used.
**************************************************************************/
STDMETHODIMP CScriptEngine::XActiveScriptSite::GetLCID(
    LCID *plcid  // address of variable for language identifier
)
{
	TRACE(TEXT("CScriptEngine::XActiveScriptSite::GetLCID\n"));
	METHOD_PROLOGUE(CScriptEngine, ActiveScriptSite)
	return E_NOTIMPL;
}

/**************************************************************************
* GetItemInfo
*
* Allows the scripting engine to obtain information about an item added 
* with IActiveScript::AddNamedItem.
**************************************************************************/
STDMETHODIMP CScriptEngine::XActiveScriptSite::GetItemInfo(
    LPCOLESTR pstrName,     // address of item name
    DWORD dwReturnMask,     // bit mask for information retrieval
    IUnknown **ppunkItem,   // address of pointer to item's IUnknown
    ITypeInfo **ppTypeInfo  // address of pointer to item's ITypeInfo
)
{
	TRACE(TEXT("**GETITEMINFO : "));
	TRACE(pstrName);
	TRACE(TEXT("\n"));

	METHOD_PROLOGUE(CScriptEngine, ActiveScriptSite)

	HRESULT hr;
	if ( wcscmp( pstrName, kScriptEngineObjectName ) == 0)
	{
		if ( dwReturnMask & SCRIPTINFO_IUNKNOWN )
		{
			TRACE(TEXT("IUNKNOWN\n"));
			*ppunkItem = this;
			AddRef();
			DebugRefCount(this,L"Iunkown for the engine");
		}

		if ( dwReturnMask & SCRIPTINFO_ITYPEINFO )
		{
			ITypeLib* pTypeLib;
			hr = pThis->GetTypeLib(GetSystemDefaultLCID(), &pTypeLib);
			if(!SUCCEEDED(hr))
			{
				TCHAR szPath[_MAX_PATH];
				GetModuleFileName(AfxGetInstanceHandle(), szPath, _MAX_PATH);
				DebugStr(TEXT("Loading Typelib from %s\n"),szPath);
				hr=LoadTypeLib(T2COLE(szPath),&pTypeLib);
			}
			if (SUCCEEDED(hr))
			{
				TRACE(TEXT("Got TypeLIB\n"));
				pTypeLib->GetTypeInfo(0, ppTypeInfo);
				pTypeLib->Release();
			}
			else
			{
				TRACE(TEXT("ERROR: GetItemInfo Could not get type info\n"));
				*ppTypeInfo = NULL;		// don't have one right now
			}
		}
	}
	else
	{
		CScriptObject obj;
		TCHAR szLower[50];

		_tcscpy(szLower,pstrName);
		_tcslwr(szLower);

		if(pThis->m_objects.Lookup(szLower,obj))
		{
			
			if ( dwReturnMask & SCRIPTINFO_IUNKNOWN )
			{
				TRACE(TEXT("IUNKNOWN\n"));
				*ppunkItem = obj.pUnk;
				if(obj.pUnk)
				{
					obj.pUnk->AddRef();
					DebugRefCount(obj.pUnk,(LPCTSTR)szLower);
				}
			}
			if ( dwReturnMask & SCRIPTINFO_ITYPEINFO )
			{
				BOOL bSuccess;
				IProvideClassInfo* pClassInfo;
				*ppTypeInfo=NULL;				
				
/*				if(obj.pUnk)
				{
					IDispatch *pDispatch;

					bSuccess=(obj.pUnk->QueryInterface(IID_IDispatch,
						(LPVOID*) &pDispatch) != E_NOINTERFACE); 
					if(bSuccess)
					{
						hr=pDispatch->GetTypeInfo(0,0,ppTypeInfo);
						pDispatch->Release();
						if(!SUCCEEDED(hr))
						{
							*ppunkItem=0;
							return TYPE_E_ELEMENTNOTFOUND;
						}
						return NOERROR;
					}
				
				}
				*/
				if(obj.pUnk)
				{
					bSuccess=(obj.pUnk->QueryInterface(IID_IProvideClassInfo2,
						(LPVOID*) &pClassInfo) != E_NOINTERFACE); 

					if(bSuccess)
						0;//pClassInfo->Release(); //**EVENTBUG
					else//**EVENTBUG
						bSuccess=(obj.pUnk->QueryInterface(IID_IProvideClassInfo,
							(LPVOID*) &pClassInfo) != E_NOINTERFACE); 
					if(bSuccess)
					{
						if( pClassInfo->GetClassInfo(ppTypeInfo) == S_OK )
							TRACE(TEXT("Got the TypeInfo for the object\n"));
						else
						{
							TRACE(TEXT("Failed to get the TypeInfo for the object\n"));
						}
						pClassInfo->Release();
					}
					else if(obj.dwFlags&OBJ_ISINTRINSIC)
					{
						ITypeLib* pTypeLib;
						HRESULT hr;

						TRACE(TEXT("Failed to get the IProvideClassInfo for the intrinsic object.  Trying TypeLib from exe.\n"));

						TCHAR szPath[_MAX_PATH];
						GetModuleFileName(AfxGetInstanceHandle(), szPath, _MAX_PATH);
						DebugStr(TEXT("Loading Typelib from %s\n"),szPath);
						hr=LoadTypeLib(T2COLE(szPath),&pTypeLib);
						if (SUCCEEDED(hr))
						{

							hr=pTypeLib->GetTypeInfoOfGuid(CLSID_IntrinsicControl, ppTypeInfo);
							pTypeLib->Release();
							if(!SUCCEEDED(hr))
							{
								*ppunkItem=0;
								return TYPE_E_ELEMENTNOTFOUND;
							}
						}
						else
							TRACE(TEXT("Failed to get the class info for the object\n"));
					}
					else
					{
						TRACE(TEXT("Failed to get the IProvideClassInfo for the object.\n"));
					}
				}
			}
		}
		else
		{
			TRACE(TEXT("OBJECT LOOKUP FAILED\n"));
			if ( dwReturnMask & SCRIPTINFO_IUNKNOWN )
				*ppunkItem=NULL;
			if ( dwReturnMask & SCRIPTINFO_ITYPEINFO )
				*ppTypeInfo=NULL;
			return TYPE_E_ELEMENTNOTFOUND;
		}
	}




  return NOERROR;
}

/**************************************************************************
* GetDocVersionString
*
* Retrieves a host-defined string that uniquely identifies the current document 
* version from the host's point of view. If the related document has changed 
* outside the scope of ActiveX Scripting (as in the case of an HTML page being 
* edited with NotePad), the scripting engine can save this along with its persisted 
* state, forcing a recompile the next time the script is loaded. 
**************************************************************************/
STDMETHODIMP CScriptEngine::XActiveScriptSite::GetDocVersionString(
    BSTR *pbstrVersionString  // address of document version string
)
{
	TRACE(TEXT("CScriptEngine::XActiveScriptSite::GetDocVersionString\n"));
	METHOD_PROLOGUE(CScriptEngine, ActiveScriptSite)
	return E_NOTIMPL;
}

/**************************************************************************
* OnScriptTerminate
*
* Informs the host that the script has completed execution. 
**************************************************************************/
STDMETHODIMP CScriptEngine::XActiveScriptSite::OnScriptTerminate(
    const struct tagVARIANT *pvarResult,   // address of script results
    const struct tagEXCEPINFO *pexcepinfo  // address of structure with exception information
)
{
	TRACE(TEXT("CScriptEngine::XActiveScriptSite::OnScriptTerminate\n"));
	METHOD_PROLOGUE(CScriptEngine, ActiveScriptSite)
	return S_OK;
}

/**************************************************************************
* OnStateChange
*
* Informs the host that the scripting engine has changed states. 
**************************************************************************/
STDMETHODIMP CScriptEngine::XActiveScriptSite::OnStateChange(
    SCRIPTSTATE ssScriptState  // new state of engine
)
{
	TCHAR *aszStates[]={L"UNINITIALIZED",L"STARTED",L"CONNECTED",L"DISCONNECTED",L"CLOSED",L"INITIALIZED"};

	//TRACE(TEXT("CScriptEngine::XActiveScriptSite::OnStateChange\n"));
	DebugStr(L"\nNew script state - %i (%s)\n",ssScriptState,aszStates[(int)ssScriptState]);
	METHOD_PROLOGUE(CScriptEngine, ActiveScriptSite)
	return S_OK;
}

/**************************************************************************
* OnScriptError
*
* Informs the host that an execution error occurred while the engine was running the script. 
**************************************************************************/
STDMETHODIMP CScriptEngine::XActiveScriptSite::OnScriptError(
    IActiveScriptError* pase  // address of error interface
)
{
	USES_CONVERSION;
	TRACE(TEXT("CScriptEngine::XActiveScriptSite::OnScriptError\n"));
	METHOD_PROLOGUE(CScriptEngine, ActiveScriptSite)
	EXCEPINFO ei;
	HRESULT res;

	res=pase->GetExceptionInfo(&ei);

	//**MARCH99 - this is all new for the bizarre case where GetExceptionInfo
	//doesn't return any information (seems to happen on PSPC Wyvern with the PSPC
	//VBScript available as of 4/99).
	if(!SUCCEEDED(res))
	{
		ei.bstrSource=CString(TEXT("VBScript failure")).AllocSysString();
		ei.bstrDescription=CString(TEXT("Unable to get exception information from scripting engine")).AllocSysString();

	}
	if(!ei.bstrSource)
		ei.bstrSource=CString(TEXT("VBScript failure")).AllocSysString();
	if(!ei.bstrDescription)
		ei.bstrDescription=CString(TEXT("no further information available from scripting engine")).AllocSysString();

	TRACE(TEXT("CCalcDlg::XActiveScriptSite::OnScriptError:"));
	TRACE(OLE2CT(ei.bstrSource));
	TRACE(TEXT(" : "));
	TRACE(OLE2CT(ei.bstrDescription));
	TRACE(TEXT("\n"));

	BSTR bstrSourceLine;
	
	res=pase->GetSourceLineText(&bstrSourceLine);
	if(!SUCCEEDED(res))
		bstrSourceLine=CString(TEXT("<Source line not available>")).AllocSysString();

	TRACE(OLE2CT(bstrSourceLine));
	TRACE(TEXT("\n"));


	DWORD dwCookie;
	ULONG nLine;
	LONG  nChar;
	pase->GetSourcePosition(&dwCookie, &nLine, &nChar);

	if((gbTrace || gbStep) && pThis->m_pcstrDebugScript) //need to adjust line number
	{
		//TCHAR szFind[20];
		ULONG nNewLine;
		ULONG iReturnCount, iBufIndex, iBufLen;

		iBufLen=pThis->m_pcstrDebugScript->GetLength();

		iReturnCount=iBufIndex=0;
		while(iBufIndex<iBufLen && iReturnCount<nLine)
		{
			TCHAR c=pThis->m_pcstrDebugScript->GetAt(iBufIndex);
			if(c==L'\n')
				iReturnCount++;
			iBufIndex++;
		}
		if(iBufIndex<iBufLen) //found our line
		{
			//scan backwards to find the comment on the line before

			//find the trailing caret ^
			while(iBufIndex && pThis->m_pcstrDebugScript->GetAt(iBufIndex)!=TEXT('^'))
				iBufIndex--;
			//is it followed by an asterisk *?
			if(pThis->m_pcstrDebugScript->GetAt(iBufIndex+1)==TEXT('*'))
			{
				iBufIndex--;
				//scan back to the leading caret ^
				while(iBufIndex && pThis->m_pcstrDebugScript->GetAt(iBufIndex)!=TEXT('^'))
					iBufIndex--;
				//assuming we found it, grab the number between the carets..
				if(iBufIndex)
				{
					nNewLine=_ttol(pThis->m_pcstrDebugScript->GetBuffer(0) + iBufIndex +1);
					
					if(nNewLine>0)
						nLine=nNewLine;
				}
			}
		}
	}

	if (pThis->m_pCurrentDocument && gbScrollToError)
	{
//		pThis->m_pCurrentDocument->doGoto(nLine,true);
      POSITION pos = pThis->m_pCurrentDocument->GetFirstViewPosition();
      CScriptView *pView = (CScriptView *)pThis->m_pCurrentDocument->GetNextView( pos );
      pView->doGoto( nLine, true, true );
      AfxGetMainWnd()->BringWindowToTop();
	}
	else
		AfxGetMainWnd()->BringWindowToTop();

	{
		TCHAR szErr[512];


		wsprintf( szErr, TEXT("%s - line %lu, char %ld\n%s\n"),
                OLE2CT(ei.bstrSource), nLine, nChar, OLE2CT(ei.bstrDescription) );
		MessageBox(pThis->m_hWnd,szErr,TEXT("Scripting Error"),MB_OK);

	}
	SysFreeString(bstrSourceLine);
	SysFreeString(ei.bstrSource);
	SysFreeString(ei.bstrDescription);
	SysFreeString(ei.bstrHelpFile);

	return NOERROR;
}

/**************************************************************************
* OnEnterScript
*
* Informs the host that the scripting engine has begun executing the script code. 
**************************************************************************/
STDMETHODIMP CScriptEngine::XActiveScriptSite::OnEnterScript(void)
{
	TRACE(TEXT("CScriptEngine::XActiveScriptSite::OnEnterScript\n"));
	METHOD_PROLOGUE(CScriptEngine, ActiveScriptSite)
	pThis->ListObjects();
	return S_OK;
}

/**************************************************************************
* OnLeaveScript
*
* Informs the host that the scripting engine has returned from executing script code. 
**************************************************************************/
STDMETHODIMP CScriptEngine::XActiveScriptSite::OnLeaveScript(void)
{
	TRACE(TEXT("CScriptEngine::XActiveScriptSite::OnLeaveScript\n"));
	METHOD_PROLOGUE(CScriptEngine, ActiveScriptSite)
	pThis->ListObjects();
	return S_OK;
}

//---------------------------------------------------------------------------
// IActiveScriptSiteWindow methods
//---------------------------------------------------------------------------
/**************************************************************************
* IMPLEMENT_IUNKNOWN
*
* This macro is defined in stdafx.h.  Implements QueryInterface, AddRef, and 
* Release (the IUnknown methods).
**************************************************************************/
IMPLEMENT_IUNKNOWN(CScriptEngine, ActiveScriptSiteWindow)

/**************************************************************************
* EnableModeless
*
* Causes the host to enable or disable its main window as well as any 
* modeless dialog boxes. 
**************************************************************************/
STDMETHODIMP CScriptEngine::XActiveScriptSiteWindow::EnableModeless(
	BOOL fEnable  // enable flag
)
{
	TRACE(TEXT("CScriptEngine::XActiveScriptSiteWindow::EnableModeless\n"));
	METHOD_PROLOGUE(CScriptEngine, ActiveScriptSiteWindow)
	return S_OK;
}

/**************************************************************************
* GetWindow
*
* Retrieves the handle of a window that can act as the owner of a pop-up 
* window that the scripting engine needs to display.  
**************************************************************************/
STDMETHODIMP CScriptEngine::XActiveScriptSiteWindow::GetWindow(
    HWND *phwnd  // address of variable for window handle
)
{
	TRACE(TEXT("CScriptEngine::XActiveScriptSiteWindow::GetWindow\n"));
	METHOD_PROLOGUE(CScriptEngine, ActiveScriptSiteWindow)

	if (!phwnd)
		return E_INVALIDARG;

	if (gpOutputWindow)
	{
		*phwnd = gpOutputWindow->m_hWnd;
	}
	else
	{
		*phwnd = NULL;
	}
	return S_OK;
}

void CScriptEngine::RunScript( LPCTSTR csScript, BOOLEAN bInitEnvironment, VARIANT *pVarResult, CScriptDoc *pDoc )
{
	USES_CONVERSION;
	HRESULT hr;
	EXCEPINFO ei;
	SCRIPTSTATE state;
	static int iParseLevel = 0;

	if( bInitEnvironment )
		InitScriptEngine();

	// Throw away the dispatch pointer..
	if( m_ddScript.m_lpDispatch )
	{
		DebugRefCount( m_ddScript, L"Releasing Dispatch Pointer" );
		m_ddScript.ReleaseDispatch();
		m_ddScript.m_lpDispatch = 0;
	}

	//is this necessary?
	__try  //**MARCH99 trying to fix eval problem.  Bad stuff happens if exception bails here
	{
		if( iParseLevel == 0 )
		{
			m_pScript->GetScriptState( &state );
			if( state == SCRIPTSTATE_CONNECTED )
			{
				hr = m_pScript->SetScriptState( SCRIPTSTATE_DISCONNECTED );
				if( !SUCCEEDED( hr ) )
				{
					TCHAR szErr[50];
					wsprintf( szErr, L"DISCONNECT failed with %lx", hr );
					::MessageBox( m_hWnd, szErr, L"STATUS", MB_OK );
				}
			}
		}
	}
	__except(EXCEPTION_EXECUTE_HANDLER)
	{
		DebugStr( TEXT("UNEXPECTED EXCEPTION SETTING SCRIPT STATE TO DISCONNECTED\n") );
	}

	m_pCurrentDocument = pDoc;

	DebugStr(L"\nabout to parse.\n");
	__try
	{
		gbExitException = false;
		iParseLevel++;
		hr = m_pParse->ParseScriptText( T2COLE(csScript),			// script text
										NULL,						// Item Name
										NULL,
										NULL,
										0,							// context cookie
										0,							// starting line number
										(pVarResult?SCRIPTTEXT_ISEXPRESSION:(SCRIPTTEXT_ISVISIBLE)),			// flags
										pVarResult,
										&ei);
	}
	__except(EXCEPTION_EXECUTE_HANDLER)
	{
		iParseLevel--;
		DebugStr( L"\nEXCEPTION!\n" );
		return;
	}

	iParseLevel--;
	DebugStr( L"\nParse returns\n" );

	if( gbExitException || !m_pScript )
	{
		gbEnterModalLoop = false;
		return;
	}

	if (m_pScript && SUCCEEDED(hr))
	{
		// then run it...
		//::MessageBox(m_hWnd,L"Parse succeeded",L"STATUS",MB_OK);

		//this line was necessary to enable multiple passes where event sinks still work..
		hr = m_pScript->SetScriptState( SCRIPTSTATE_STARTED );
		hr = m_pScript->SetScriptState( SCRIPTSTATE_CONNECTED );
		if( !SUCCEEDED( hr ) )
		{
			TCHAR szErr[50];
			wsprintf( szErr, L"Failed to set state with err %lx", hr );
			::MessageBox( m_hWnd, szErr, L"FATAL ERROR", MB_OK );
		}
	}
	else
	{
		TCHAR szErr[50];
		wsprintf(szErr,L"Parse failed with %lx",hr);
		//::MessageBox(m_hWnd,szErr,L"STATUS",MB_OK);
		DebugStr(L"%s\n",szErr);
		return;
	}
	//::MessageBox(m_hWnd,L"Getting IDispatch",L"STATUS",MB_OK);

	LPDISPATCH pDisp;

	hr = m_pScript->GetScriptDispatch(NULL, &pDisp);
	if (SUCCEEDED(hr))
	{
		DebugRefCount(pDisp,L"AttachDispatch");
		m_ddScript.AttachDispatch(pDisp,true);
		//::MessageBox(m_hWnd,L"IDispatch succeeded",L"STATUS",MB_OK);
	}
	else
	{
		//::MessageBox(m_hWnd,L"IDispatch failed",L"STATUS",MB_OK);
		TRACE(TEXT("ERROR getting Script Dispatch pointer\n"));
	}

	//::MessageBox(m_hWnd,L"Releasing IDispatch",L"STATUS",MB_OK);
	DebugStr(L"\ngot to end of runscript\n");
	return;
}

BOOLEAN CScriptEngine::AddScriptLibrary(LPCTSTR szName, HINSTANCE library, DWORD dwFlags)
{//hwnd parameter is ignored..
	CScriptObject obj;
	HRESULT hr;
	TCHAR szTemp[100];
	CLibraryDispatch *dispatch;
	int k;

	_tcscpy(szTemp,szName);
	_tcslwr(szTemp);

	/* Change all weird characters to underscores */
	for (k = 0; szTemp[k]; ++k)
	{
		if (ia(szTemp[k]) || id(szTemp[k]))
		{
		}
		else
		{
			szTemp[k] = '_';
		}
	}

	if(m_objects.Lookup(szTemp,obj))
	{
		m_objects.RemoveKey(szTemp);
	}

	obj.pCWnd = NULL;
	obj.cstrLabel=szName;
	obj.dwFlags=dwFlags;
	dispatch = new CLibraryDispatch(library);
	dispatch -> AddRef();
	obj.pUnk = dispatch;

	m_objects.SetAt(szTemp,obj);

	//DebugStr(TEXT("Object %s is %s an event source.\n"),szName,dwFlags&OBJ_ISSOURCE?L"":L"not");
	hr = m_pScript->AddNamedItem(szTemp, SCRIPTITEM_ISVISIBLE | ((dwFlags&OBJ_ISSOURCE)?SCRIPTITEM_ISSOURCE:0) );

	if(SUCCEEDED(hr))
	{
//		TCHAR szBuf[100];
//		wsprintf( szBuf, _T("pCWnd: %lx, pUnk: %lx, hWnd: %lx"), pCWnd, pUnk, hWnd );
//		AfxGetMainWnd()->MessageBox( szBuf, _T("AddScriptObject"), MB_OK );
		return true;
	}
	else
	{
		TCHAR szBuf[50];
		wsprintf(szBuf,L"%lx",hr);
		AfxGetMainWnd()->MessageBox(szBuf,L"Error adding object to namespace",MB_OK);
		return false;
	}	
}

BOOLEAN CScriptEngine::AddScriptObject(LPCTSTR szName,CWnd *pCWnd,HWND hWnd,IUnknown *pUnk, DWORD dwFlags)
{//hwnd parameter is ignored..
	CScriptObject obj;
	HRESULT hr;
	TCHAR szTemp[50];

	_tcscpy(szTemp,szName);
	_tcslwr(szTemp);

	if(m_objects.Lookup(szTemp,obj))
	{
		m_objects.RemoveKey(szTemp);
	}

	obj.pCWnd=pCWnd;
	//obj.hWnd=hWnd;
	obj.pUnk=pUnk;
	obj.cstrLabel=szName;
	obj.dwFlags=dwFlags;

#if 0
	/* Give the control an advise sink for dumb events */
	if (pUnk)
	{
		IConnectionPointContainer *cpc;
		HRESULT hr;
		
		hr = pUnk -> QueryInterface(IID_IConnectionPointContainer, (void **)&cpc);
		if (SUCCEEDED(hr))
		{
			IEnumConnectionPoints *cps;

			hr = cpc -> EnumConnectionPoints(&cps);
			if (SUCCEEDED(hr))
			{
				cps->Reset();

				for (;;)
				{
					IConnectionPoint *cp;
					ULONG fetched;

					hr = cps -> Next(1, &cp, &fetched);

					if (SUCCEEDED(hr) && fetched)
					{
						IID id;
						cp -> GetConnectionInterface(&id);  // DIKEO means nothing now, maybe use it later
					}
					else
					{
						break;
					}
				}
				cps -> Release();
			}
			cpc -> Release();
		}
	}
#endif

	m_objects.SetAt(szTemp,obj);

	//DebugStr(TEXT("Object %s is %s an event source.\n"),szName,dwFlags&OBJ_ISSOURCE?L"":L"not");
	hr = m_pScript->AddNamedItem(szTemp, SCRIPTITEM_ISVISIBLE | ((dwFlags&OBJ_ISSOURCE)?SCRIPTITEM_ISSOURCE:0) );

	if(SUCCEEDED(hr))
	{
//		TCHAR szBuf[100];
//		wsprintf( szBuf, _T("pCWnd: %lx, pUnk: %lx, hWnd: %lx"), pCWnd, pUnk, hWnd );
//		AfxGetMainWnd()->MessageBox( szBuf, _T("AddScriptObject"), MB_OK );
		return true;
	}
	else
	{
		TCHAR szBuf[50];
		wsprintf(szBuf,L"%lx",hr);
		AfxGetMainWnd()->MessageBox(szBuf,L"Error adding object to namespace",MB_OK);
		return false;
	}	
}

BOOL CScriptEngine::AddControl(LPCTSTR Class, LPCTSTR Name, short Left, short Top, short Width, short Height) 
{
	CWnd *pCWnd;

	pCWnd=new(CWnd);

	if(!pCWnd->CreateControl(Class, Name,
		WS_VISIBLE|WS_EX_NOANIMATION, CRect(Left,Top,Left+Width,Top+Height), m_pcWnd?m_pcWnd:AfxGetMainWnd(), 1) )
	{
		AfxGetMainWnd()->MessageBox(TEXT("Error Creating control\n"),TEXT("FAIL"),MB_OK);
		return false;
	}
	pCWnd->BringWindowToTop();
	pCWnd->ShowWindow(SW_SHOW);
	pCWnd->UpdateWindow();
	
	return AddScriptObject(Name,pCWnd,pCWnd->m_hWnd,pCWnd->GetControlUnknown(),OBJ_ACTIVEXCONTROL);
}

void CScriptEngine::execute(LPCTSTR szScript) 
{
	enum {fileNONE,fileASCII, fileUNICODE} filetype = fileNONE;

	const TCHAR *pScript = szScript;
	LPVOID hTextTemp = 0;
	LPVOID hTextConverted = 0;
	int iTagLen = 0;

	// Look for file descriptor tag
	if( _tcsnicmp( pScript, TEXT("file:"), 5 ) == 0 )
	{
		filetype = fileASCII;
		iTagLen = 5;
	}
	else if( _tcsnicmp( pScript, TEXT("ascii:"), 6 ) == 0 )
	{
		filetype = fileASCII;
		iTagLen = 6;
	}
	else if( _tcsnicmp( pScript, TEXT("unicode:"), 8 ) == 0 )
	{
		filetype = fileUNICODE;
		iTagLen = 8;
	}

	if( filetype != fileNONE )
	{
		const TCHAR *pFileName=pScript+iTagLen; //**JULY99 fixed to skip right # of chars//5; //skip the 'file:' tag
		HANDLE hFile;
		DWORD  dwSize,dwRead;
		TCHAR *szTextTemp=0,*szTextConverted=0;
		DWORD dwErr;

		hFile=::CreateFile(pFileName,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if(hFile==INVALID_HANDLE_VALUE)
		{
			dwErr=GetLastError();
			if(dwErr==ERROR_FILE_NOT_FOUND)	
				AfxThrowOleDispatchException(kEXCEPTION_INVALID_ARGUMENTS,IDS_EXCEPTION_FILENOTFOUND);
			else
				AfxThrowOleDispatchException(kEXCEPTION_INVALID_ARGUMENTS,IDS_EXCEPTION_CANTLOAD);
			return;
		}
		dwSize=::GetFileSize(hFile,NULL);
		hTextTemp=LocalAlloc(LPTR,dwSize+2);
		if(hTextTemp==INVALID_HANDLE_VALUE)
		{//do we need a better exception here?
			AfxThrowOleDispatchException(kEXCEPTION_NOMEMORY,IDS_EXCEPTION_NOMEMORY);
			return;
		}
		if(filetype==fileASCII)
		{//need conversion buffer
			hTextConverted=LocalAlloc(LPTR,((filetype==fileASCII?2:1)*(dwSize+1)));
			if(hTextConverted==INVALID_HANDLE_VALUE)
			{//do we need a better exception here?
				LocalFree(hTextTemp);
				AfxThrowOleDispatchException(kEXCEPTION_NOMEMORY,IDS_EXCEPTION_NOMEMORY);
				return;
			}
			szTextConverted=(LPTSTR)LocalLock(hTextConverted);
		}
			
		szTextTemp=(LPTSTR)LocalLock(hTextTemp);
		//read into the temp buffer
		::ReadFile(hFile,szTextTemp,dwSize,&dwRead,NULL);
		szTextTemp[dwSize]=0;
		DWORD i=0;
		
		if(filetype==fileUNICODE)
		{
			while(i<dwSize)
			{
				TCHAR c=szTextTemp[i];
				bool b1=c>0xF000;
				bool b2=c==TEXT('\r');
				if(b1 || b2)
					szTextTemp[i]=TEXT(' ');
				i++;
			}
			pScript=szTextTemp;
		}
		else
		{
			mbstowcs(szTextConverted,(char *)szTextTemp,dwSize);
			pScript=szTextConverted;
		}
		if(hTextTemp)
			LocalUnlock(hTextTemp);
		if(hTextConverted)
			LocalUnlock(hTextConverted);
		//CloseHandle(hFile);
	}
	else
		pScript = szScript;

	RunScript( pScript, false, NULL, m_pCurrentDocument );

	if( hTextConverted )
		LocalFree( hTextConverted );
	if( hTextTemp )
		LocalFree( hTextTemp );
}

VARIANT CScriptEngine::eval(LPCTSTR szExpression) 
{
	VARIANT vaResult;
	VariantInit(&vaResult);

	__try //**MARCH99 shot in the dark to fix eval issue on some units?
	{
		RunScript(szExpression,false,&vaResult);
	}
	__except(EXCEPTION_EXECUTE_HANDLER)
	{
		DebugStr(TEXT("UNEXPECTED EXCEPTION RUNNING EVAIL!!")); 
	}
	return vaResult;
}

bool doAddParmToString(CString *pStr, const VARIANT FAR * text, BOOLEAN bTab=true)
{
	VARIANT v;

	if(bTab)
		*pStr+=TEXT("\t"); //add a tab

	if(text->vt!=VT_EMPTY && text->vt!=VT_ERROR)
	{
		VariantInit(&v);
		VariantCopyInd(&v,(VARIANT *)text);
		VariantChangeType(&v,&v,VARIANT_NOVALUEPROP,VT_BSTR);

		*pStr+=(LPCTSTR)v.bstrVal;

		return false;
	}
	else
	{
		return true;
	}
}

void CScriptEngine::print(const VARIANT FAR& text1,const VARIANT FAR& text2,const VARIANT FAR& text3,
						const VARIANT FAR& text4,const VARIANT FAR& text5,const VARIANT FAR& text6,
						const VARIANT FAR& text7,const VARIANT FAR& text8,const VARIANT FAR& text9,
						const VARIANT FAR& text10,const VARIANT FAR& text11,const VARIANT FAR& text12,
						const VARIANT FAR& text13,const VARIANT FAR& text14,const VARIANT FAR& text15,
						const VARIANT FAR& text16,const VARIANT FAR& text17,const VARIANT FAR& text18,
						const VARIANT FAR& text19,const VARIANT FAR& text20)
{
#define kNumVarParms 20
	CNewOutputDialog *pDlg;
	CString cstrParms;
	const VARIANT *avParms[kNumVarParms];
	int i, iLastParm;

	if(!m_pcWnd)
		return;

	pDlg=(CNewOutputDialog *)m_pcWnd;


	cstrParms.Empty();


	avParms[0]=&text1;
	avParms[1]=&text2;
	avParms[2]=&text3;
	avParms[3]=&text4;
	avParms[4]=&text5;
	avParms[5]=&text6;
	avParms[6]=&text7;
	avParms[7]=&text8;
	avParms[8]=&text9;
	avParms[9]=&text10;
	avParms[10]=&text11;
	avParms[11]=&text12;
	avParms[12]=&text13;
	avParms[13]=&text14;
	avParms[14]=&text15;
	avParms[15]=&text16;
	avParms[16]=&text17;
	avParms[17]=&text18;
	avParms[18]=&text19;
	avParms[19]=&text20;

	iLastParm=kNumVarParms-1;
	for(i=kNumVarParms-1;i>=0;i--)
		if(avParms[i]->vt!=VT_EMPTY && avParms[i]->vt!=VT_ERROR)
			break;
		else
			iLastParm=i-1;


	i=0;
	while(i<=iLastParm)
	{
		doAddParmToString(&cstrParms,avParms[i],i!=0);
		i++;
	}

	cstrParms+=TEXT("\r\n");

#undef kNumVarParms
	
	//DebugStr(L"PRINT : %s",cstrParms);

	int iEnd;
	int iStrLen=cstrParms.GetLength();
	iEnd=pDlg->m_EditControl.GetWindowTextLength();
	pDlg->m_EditControl.SetSel(iEnd,iEnd);

	
	pDlg->m_EditControl.ReplaceSel(cstrParms);

	// pDlg->m_PictureBox.RedrawWindow(NULL,NULL,RDW_INTERNALPAINT|RDW_INVALIDATE|RDW_NOERASE|RDW_UPDATENOW);

	// Handle with S309PictureBox
	HDC hdc;
	RECT rectMe;
	int iFirstChar, iNumLines,iTopLine;
	TEXTMETRIC tm;
	CString cstrText;

	hdc=::GetDC(pDlg->m_PictureBox2.GetHWND());
	GetTextMetrics(hdc,&tm);

	::GetClientRect(this->m_hWnd,&rectMe);

	iNumLines=pDlg->m_PictureBox2.GetHeight()/(tm.tmHeight-1);

	iTopLine=max(0,pDlg->m_EditControl.GetLineCount()-iNumLines);
	
	{
		RECT rect;
		::GetClientRect(pDlg->m_EditControl.m_hWnd,&rect);
	}

	iFirstChar=iTopLine?pDlg->m_EditControl.LineIndex(iTopLine):0;
	pDlg->m_EditControl.SetSel(-1,0,false); //no selection
	if(iFirstChar<=0)
		iFirstChar=0;
	else
	{//if the first line isn't the first char, chuck whats above the top.  We don't
	 //want it anymore...
		pDlg->m_EditControl.SetSel(0,iFirstChar,true);
		pDlg->m_EditControl.ReplaceSel(TEXT(""));
		iEnd=pDlg->m_EditControl.GetWindowTextLength();
		pDlg->m_EditControl.SetSel(0,0,false);
		pDlg->m_EditControl.SetSel(iEnd,iEnd);
	}

	int length = pDlg->m_EditControl.GetWindowTextLength() + 1;
	BSTR winText = SysAllocStringLen(NULL, length);
	pDlg->m_EditControl.GetWindowText(winText, length);
	//::DrawText(hdc,(LPCTSTR)cstrText,-1,&rectMe,DT_EXPANDTABS|DT_NOCLIP|DT_WORDBREAK);
	pDlg->m_PictureBox2.SetCaption(winText);
	SysFreeString(winText);

	::ReleaseDC(this->m_hWnd,hdc);
}

long CScriptEngine::MsgBox(const VARIANT FAR& prompt,const VARIANT FAR& buttons,const VARIANT FAR& title)
{
	CString cstrPrompt;
	CString cstrTitle = L"NSBasic";
	int b = MB_OK;

	cstrPrompt.Empty();

	if (VT_EMPTY != prompt.vt)
	{
		/* Add the prompt */
		doAddParmToString(&cstrPrompt, &prompt, false);
	}

	if (VT_EMPTY != buttons.vt)
	{
		VARIANT v;
		HRESULT result;

		VariantInit(&v);
		result = VariantChangeType(&v, (VARIANTARG *)&buttons, 0, VT_I4);
		b=v.lVal;
	}

	if (VT_EMPTY != title.vt)
	{
		/* Add the title */
		cstrTitle.Empty();
		doAddParmToString(&cstrTitle, &title, false);
	}

	return ::MessageBox(NULL, cstrPrompt, cstrTitle, b | MB_SETFOREGROUND);
}

/*	Usage example for SendScriptMessage

	VARIANT result;
	unsigned char parms[]=VTS_BSTR VTS_BSTR VTS_I4;

	if(!EnsureOutputWindowOpen())
		return;

	pENGINE->SendScriptMessage(L"on_test",VT_VARIANT,&result,parms,L"Hello",L"There",666);
*/

BOOL CScriptEngine::SendScriptMessage(const TCHAR *szMember, VARTYPE vtRet,  void *pvarResult, const BYTE FAR* pbParamInfo, ... )
{
	//if (!m_ddScript.m_lpDispatch)		// never was attached
	//	false;
	
	HRESULT hr;
	//OLECHAR FAR* szMember = (LPCTSTR)cstrMethodName;
	DISPID  id;

 	if(!m_ddScript.m_lpDispatch)
	{
		TRACE(TEXT("Aborting SendScriptMessage because there is no dispatch driver - "));
		TRACE(szMember);
		TRACE(TEXT("\n"));
		return false;
	}
	//TRY
	__try
	{
	hr = m_ddScript.m_lpDispatch->GetIDsOfNames(IID_NULL,
						(OLECHAR**)&szMember,
						1,
						GetSystemDefaultLCID(),
						&id);
	}
	//CATCH(COleException, pex)
	__except(EXCEPTION_EXECUTE_HANDLER)
	{
		TRACE(TEXT("Exception getting DispID for "));
		TRACE(szMember);
		TRACE(TEXT("\n"));
		return false;
	}
	//END_CATCH

	if (!SUCCEEDED(hr))
	{
		TRACE(TEXT("Error getting DispID for "));
		TRACE(szMember);
		TRACE(TEXT("\n"));
		return false;
	}

	//TRY
	__try
	{
		//static BYTE BASED_CODE  csParms []=VTS_BSTR;
		va_list args;

		va_start (args,pbParamInfo);
		m_ddScript.InvokeHelperV(id, 
						DISPATCH_METHOD,
						vtRet,
						pvarResult,
						pbParamInfo,
						args);
		va_end(args);
	}
	//CATCH(COleDispatchException, pex)
	__except(EXCEPTION_EXECUTE_HANDLER)
	{
		//CString msg = pex->m_strSource + " " + pex->m_strDescription + "\n";
		//TRACE( msg );
		///AfxMessageBox( msg );
	}
	//END_CATCH
	return true;
}

DISPID CScriptEngine::ParseID(CWnd *pCWnd, IDispatch *pDisp)
{
	DISPID retVal = 0;

	if (!pDisp)
	{
		pDisp = pCWnd->GetIDispatch(false);
	}

	SkipBlanks();

	if ((*s >= 'a' && *s <= 'z') || (*s >= 'A' && *s <= 'Z'))
	{
		TCHAR *ss;
		BSTR symbol;
		HRESULT result;

		for (ss = s; 
			 (*s >= 'a' && *s <= 'z') || (*s >= 'A' && *s <= 'Z') || 
			 (*s >= '0' && *s <= '9') || ('_' == *s);
			 ++s) {}

		symbol = SysAllocStringLen(ss, s - ss);

		result = pDisp -> GetIDsOfNames(IID_NULL, &symbol, 1, LANG_NEUTRAL | SUBLANG_NEUTRAL, &retVal);

		SysFreeString(symbol);
	}

	return retVal;
}

void CScriptEngine::ParseExpression(VARIANT *v)
{
	SkipBlanks();

	if (*s >= '0' && *s <= '9')
	{
		int i = 0;

		while (*s >= '0' && *s <= '9')
		{
			i = i * 10 + (*s - '0');
			++s;
		}
		v -> vt = VT_I4;
		v -> lVal = i;
	}
	else if ('"' == *s)
	{
		++s;
		TCHAR *ss = s;

		while (*s)
		{
			if ('"' == *s) {break;}
			++s;
		}

		v -> vt = VT_BSTR;
		v -> bstrVal = SysAllocStringLen(ss, s - ss);
		if ('"' == *s) ++s;
	}
}

void CScriptEngine::ParseAssignment(CWnd *pCWnd, IDispatch *pDisp)
{
	DISPID id = ParseID(pCWnd, pDisp);

	SkipBlanks();
	if ('=' == *s)
	{
		VARIANT v;
		++s;

		VariantInit(&v);

		ParseExpression(&v);

#if 0
		HRESULT result;
		unsigned int e;
		DISPPARAMS params;

		params.rgvarg = &v;
		params.rgdispidNamedArgs = NULL;
		params.cArgs = 1;
		params.cNamedArgs = 0;

		result = pDisp->Invoke(id, IID_NULL, LANG_NEUTRAL | SUBLANG_NEUTRAL, DISPATCH_PROPERTYPUT,
			&params, NULL, NULL, &e);
#else
		if (!pCWnd)
		{
			COleDispatchDriver driver;

			driver.AttachDispatch(pDisp, FALSE);
			BYTE vals[2] = {0, 0};

			TRY
				switch (v.vt)
				{
					case VT_I4:
						vals[0] = VT_I4;
						driver.InvokeHelper(id, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL,
						vals, v.lVal);
						break;
					case VT_BSTR:
						vals[0] = VT_BSTR;
						driver.InvokeHelper(id, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL,
						vals, v.bstrVal);
						break;
				}
			CATCH(COleDispatchException, pex)
				//::MessageBox(NULL, L"Foo", L"EMP", MB_OK);
			END_CATCH

			driver.DetachDispatch();
		}
		else
		{
			BYTE vals[2] = {0, 0};

			TRY
				switch (v.vt)
				{
					case VT_I4:
						vals[0] = VT_I4;
						pCWnd->InvokeHelper(id, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL,
						vals, v.lVal);
						break;
					case VT_BSTR:
						vals[0] = VT_BSTR;
						pCWnd->InvokeHelper(id, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL,
						vals, v.bstrVal);
						break;
				}
			CATCH(COleDispatchException, pex)
				//::MessageBox(NULL, L"Foo", L"EMP", MB_OK);
			END_CATCH
		}
#endif
	}
}

void CScriptEngine::ParseProps(CWnd *pCWnd, BSTR props, IDispatch *pDispatch)
{
	if (!props) return;

	s = props;

	SkipBlanks();

	ParseAssignment(pCWnd, pDispatch);

	SkipBlanks();

	while (':' == *s)
	{
		++s;

		ParseAssignment(pCWnd, pDispatch);
		SkipBlanks();
	}
}

LPUNKNOWN CScriptEngine::AddObjectHelper(const CString &cstrName, const CString &cstrCaption, const CString &cstrParent,
								LPUNKNOWN lpUnknownP,
								const BSTR type, BSTR license, const BSTR props,
							    int iTop, int iLeft, int iWidth, int iHeight,
								CIntrinsicControl **intrinsicControl)
{
	
	CString cstrClass;
	//CString cstrTemp;
	CWnd *pCWnd;
	static int iChildID=12000;
	HRESULT hr;
	BOOL bIsWindow=false;
	IUnknown *pUnk=NULL;
	CLSID clsid;
	DWORD dwObjectFlags=0;
	void *vptr;
	IntrinsicObject *ioWhich=0;
	CWnd *pCWndP;

	if(iLeft==1000 && iLeft==1000 && iWidth==5 && iHeight==5)
		bIsWindow=false;
	else
		bIsWindow=true;

	// Find the CWnd pointer to the parent
	// Option 1: m_pcWnd (default)
	// Option 2: AfxGetMainWnd
	// Option 3: vUnknown arg passed in to AddObject call as 7th parameter
	pCWndP = NULL;

	if( lpUnknownP )
	{
		LPDISPATCH lpDispP;

		// First get IDispatch pointer to parent
		// Then get CWnd from IDispatch, if possible
		hr = lpUnknownP->QueryInterface( IID_IDispatch, (void**)&lpDispP );
		if( SUCCEEDED(hr) )
			pCWndP = (CWnd *)CCmdTarget::FromIDispatch( lpDispP );
	}
	if( pCWndP == NULL )
	{
		pCWndP = m_pcWnd ? m_pcWnd : AfxGetMainWnd();
	}

	//lookup first to see if it's an intrinsic
	if( m_IntrinsicLookup.Lookup(type, vptr ) )
	{
		IDispatch *pDisp;
		
		ioWhich = (IntrinsicObject *)vptr;

		if( !bIsWindow )
		{
			AfxThrowOleDispatchException( kEXCEPTION_INVALID_ARGUMENTS, IDS_EXCEPTION_INVALID_ARGUMENTS );
			return NULL;
		}

		*intrinsicControl = new(CIntrinsicControl); 
		pCWnd = (CWnd *) *intrinsicControl;

		//pCWnd->CreateEx(ioWhich->dwExStyle|WS_EX_NOANIMATION,ioWhich->szClass,cstrName,ioWhich->dwStyle|WS_VISIBLE,
		//				CRect(iLeft,iTop,iLeft+iWidth,iTop+iHeight), m_pcWnd?m_pcWnd:AfxGetMainWnd(), iChildID++);

		( (CIntrinsicControl *)pCWnd)->m_pioThis = ioWhich;
		( (CIntrinsicControl *)pCWnd)->m_cstrName = cstrName;
		if( lpUnknownP )
		{
			( (CIntrinsicControl *)pCWnd)->m_cstrParent = ( (CIntrinsicControl *)pCWndP)->m_cstrName;
		}
		else
		{
			( (CIntrinsicControl *)pCWnd)->m_cstrParent = "not on form";
		}
		( (CIntrinsicControl *)pCWnd)->SetTabStop(ioWhich->dwStyle & WS_TABSTOP ? true : false);
		( (CIntrinsicControl *)pCWnd)->FindTabPosition();

		( (CIntrinsicControl *)pCWnd)->m_dwExStyle = ioWhich->dwExStyle; //later, we may accept styles in the call to this function

		pCWnd->CreateEx( ioWhich->dwExStyle, ioWhich->szClass, _T(""), ioWhich->dwStyle,
						iLeft, iTop, iWidth, iHeight, pCWndP->m_hWnd, (HMENU)(iChildID++), 0 );
		//get an IUnknown (can't use GetControlUnknown here because it's not an ActiveX control)
		pDisp = pCWnd->GetIDispatch( true );
		pDisp->QueryInterface( IID_IUnknown, (void **)&pUnk );

		ParseProps(NULL, props, pDisp);

		pDisp->Release();
		pCWnd->BringWindowToTop();

		bIsWindow = true;
		dwObjectFlags = OBJ_INTRINSICCONTROL;
	}
	else
	{
		// non-intrinsic
		// lookup the long name from the short name, and if it doesn't exist, use the short name as-is
		if( !m_GuidLookup.Lookup(type, cstrClass ) )
			cstrClass = type;

		// Get the classID
		hr = LookupCLSID( cstrClass, &clsid );
		if( !SUCCEEDED( hr ) )
		{
			TCHAR szBuf[100];

			wsprintf( szBuf, TEXT("Unable to resolve Class ID for '%s' when instantiating '%s' object."), cstrClass, type );
			AfxThrowOleDispatchException( kEXCEPTION_CLASSNOTFOUND, szBuf );

			return NULL;
		}

		pCWnd = new(CWnd);

		//CFile bf(L"\\rg.bin", CFile::modeReadWrite);

		if( !bIsWindow || 
			!pCWnd->CreateControl( clsid, cstrCaption, WS_VISIBLE, CRect( iLeft, iTop, iLeft + iWidth, iTop + iHeight ), pCWndP, iChildID++,
			NULL, false, (license && license[0]) ? license : NULL) )
		{
			// can't create window, or user provided no coords to create a window
			long err = GetLastError();

			delete pCWnd;
			pCWnd = 0;

			// try instantiating non-visual control
			IClassFactory2 *pCF;
		
			hr = CoGetClassObject( clsid, CLSCTX_INPROC_SERVER, NULL, IID_IClassFactory2, (void **)&pCF ); 
			if (FAILED(hr))
			{
				hr = CoGetClassObject( clsid, CLSCTX_INPROC_SERVER, NULL, IID_IClassFactory, (void **)&pCF ); 
				if (license)
				{
					license = NULL;
				}
			}
			if( SUCCEEDED( hr ) )
			{
				if (license && license[0])
				{
					hr = pCF->CreateInstanceLic( NULL, NULL, IID_IUnknown, license, (void **)&pUnk );
				}
				else
				{
					hr = pCF->CreateInstance( NULL, IID_IUnknown, (void **)&pUnk );
				}

				if (SUCCEEDED(hr))
				{
					HRESULT result;
					IDispatch *pDispatch = NULL;
					result = pUnk->QueryInterface(IID_IDispatch, (void **)(&pDispatch));

					ParseProps(NULL, props, pDispatch);

					if (pDispatch) pDispatch->Release();
				}

				//release the Class Factory interface...
				//I believe we have a reference-counted ref to IUnknown..
				DebugRefCount( pCF,L"ClassFactory" );
				DebugRefCount( pUnk,L"IUnknown" );
				//pUnk->AddRef();
				pCF->Release();
				//test code return pUnk;
				DebugRefCount( pUnk, L"IUnknown after ClassFactory is released" );
				dwObjectFlags = OBJ_ISSOURCE; //neither an ActiveX control, nor an intrinsic
			}
			else
			{
				//CoGetClassObject failed.
				TCHAR szBuf[250];

				wsprintf( szBuf, L"Could not create non-visual control ('%s') because IClassFactory could not be obtained, (err %lx) (%s as %s, child id %i) at %i,%i/%i,%i", type, hr, cstrClass, cstrName, iChildID, iLeft, iTop, iWidth, iHeight );
				AfxThrowOleDispatchException( kEXCEPTION_NOCLASSFACTORY, szBuf );

				return NULL;
			}
		}
		else
		{
			//createcontrol succeeded..
			//DebugStr(L"Created Window (%s as %s)\n",cstrClass,cstrName);
			DebugRefCount( pCWnd->GetControlUnknown(), L"Window Unknown" );
			bIsWindow = true;
			pUnk = pCWnd->GetControlUnknown();

			IDispatch *pDispatch = NULL;
			pUnk->QueryInterface(IID_IDispatch, (void **)(&pDispatch));

			ParseProps(pCWnd, props, pDispatch);
			
			if (pDispatch) pDispatch->Release();
			pCWnd->BringWindowToTop();

			//pCWnd->ShowWindow(SW_SHOW);
			//pCWnd->UpdateWindow();
			dwObjectFlags = OBJ_ACTIVEXCONTROL;
		}
		hr = m_pScript->SetScriptState( SCRIPTSTATE_STARTED );
		hr = m_pScript->SetScriptState( SCRIPTSTATE_CONNECTED );
	}//non-intrinsic

	if( AddScriptObject( cstrName, bIsWindow ? pCWnd : 0, bIsWindow ? (pCWnd->m_hWnd) : 0, pUnk, dwObjectFlags ) )
	{
		//DebugStr(L"AddScriptObject for (%s as %s) succeeded (%s)\n",cstrClass,cstrName,bIsWindow?L"Window":L"Not Window");
		DebugRefCount( pUnk, (LPCTSTR)cstrName );
		m_hLastHWND = bIsWindow ? pCWnd->m_hWnd : 0;

		pUnk->AddRef(); //if you don't do this, then apparently VBScript tries to free it and crashola.
		return pUnk;
	}
	else
	{
		//AddScriptObject failed!!
		TCHAR szBuf[100];

		//DebugStr(L"AddScriptObject for (%s as %s) failed.\n",cstrClass,cstrName);
		DebugRefCount( pUnk, L"IUnknown before release if not a window" );
		if( bIsWindow )
			pCWnd->DestroyWindow();
		else if( pUnk )
			pUnk->Release();
		m_hLastHWND = 0;

		wsprintf( szBuf,TEXT("Unable to add '%s' object to script name space (%s as %s)."), type, cstrClass, cstrName );
		AfxThrowOleDispatchException( kEXCEPTION_CANTADDNAME, szBuf );

		return NULL;
	}

	return NULL;
}
							

LPUNKNOWN CScriptEngine::AddObject(LPCTSTR szObject, const VARIANT FAR& vVariableName, const VARIANT FAR& vLeft, const VARIANT FAR& vTop, const VARIANT FAR& vWidth, const VARIANT FAR& vHeight, const VARIANT FAR& vUnknown) 
{
	CString cstrName, cstrParent;
	int iTop,iLeft,iWidth,iHeight;
	BSTR type = NULL;
	BSTR license = NULL, props = NULL;
	LPUNKNOWN lpUnknownP;
	CString cstrCaption;
	CScriptObject obj;
	
	/* Extract variables from variants */
	//convert object name to lower case so we can do a lookup to figure out what it is
	//_tcscpy(szLower,szObject);
	/* Parse the szObject into type, license, and props */
	int b, e;

	b = 0;
	for (e = b; szObject[e] && (e < 2 || ':' != szObject[e]); ++e) {}
	type = SysAllocStringLen(&(szObject[b]), e - b);
	b = e;
	while (' ' == szObject[b]) ++b;
	if (':' == szObject[b])
	{
		++b;
		for (e = b; szObject[e] && ':' != szObject[e]; ++e){}
		license = SysAllocStringLen(&(szObject[b]), e - b);
		b = e;
		while (' ' == szObject[b]) ++b;
		if (':' == szObject[b])
		{
			++b;
			for (e = b; szObject[e]; ++e){}
			props = SysAllocStringLen(&(szObject[b]), e - b);
		}
	}

	//get the variable name which will represent the object.  Use type as the default
	cstrName=doExtractCStringFromVariant(&vVariableName,type);
	cstrParent=doExtractCStringFromVariant(&vUnknown,type);
	iLeft=doExtractIntFromVariant(&vLeft,1000);
	iTop=doExtractIntFromVariant(&vTop,1000);
	iWidth=doExtractIntFromVariant(&vWidth,5);
	iHeight=doExtractIntFromVariant(&vHeight,5);

	cstrCaption=cstrName; //cstrCaption retains the original case
	cstrName.MakeLower();

	_tcslwr(type);

	if(m_objects.Lookup(cstrName,obj))
	{
		TCHAR szBuf[100];
		wsprintf(szBuf,TEXT("An object called '%s' already exists"),cstrCaption);

		AfxThrowOleDispatchException(kEXCEPTION_OBJECTEXISTS,szBuf);
		if (type) SysFreeString(type);
		if (license) SysFreeString(license);
		if (props) SysFreeString(props);
		return NULL;
	}	

	lpUnknownP = doExtractLPUNKNOWNFromVariant( &vUnknown, NULL );
	LPUNKNOWN retVal = NULL;
	CIntrinsicControl *control = NULL;

	if (wcscmp(L"listbox", type) == 0 ||
		wcscmp(L"date", type) == 0 ||
		wcscmp(L"time", type) == 0)

	{
		/* For these objects, need to make a focus rectangle and put the control inside.*/
		CString frName = cstrName + L"_focusRect";
		CIntrinsicControl *frControl = NULL, *childControl = NULL;

		LPUNKNOWN focusRect = AddObjectHelper(frName, L"", cstrParent, lpUnknownP,
			L"focusrect", L"", L"", iTop - FOCUSBORDER, iLeft - FOCUSBORDER, 
			iWidth + 2 * FOCUSBORDER, iHeight + 2 * FOCUSBORDER, &frControl);

		if (focusRect)
		{
			retVal = AddObjectHelper(cstrName, cstrCaption, cstrParent, focusRect, 
			type, license, props, 2, 2, iWidth, iHeight, &childControl);

			if (childControl && frControl)
			{
				RECT rectChild;
				childControl->GetClientRect(&rectChild);
				int height = rectChild.bottom - rectChild.top;

				if (0 == wcscmp(L"listbox", type))
				{
					/* Adjust height to be an integral number of lines */
					int itemHeight = childControl->SendMessage(LB_GETITEMHEIGHT, 0, 0);
					int nItems = height / (itemHeight - 2);
					height = nItems * (itemHeight - 2);
				}

				frControl->SetHeight(height + 2 * FOCUSBORDER);

				frControl->m_focusChild = childControl;
				childControl->m_focusParent = frControl;
			}
		}
		else
		{
			retVal = AddObjectHelper(cstrName, cstrCaption, cstrParent, lpUnknownP, 
			type, license, props, iTop, iLeft, iWidth, iHeight, &control);
		}

	}
	else
	{
		retVal = AddObjectHelper(cstrName, cstrCaption, cstrParent, lpUnknownP, 
			type, license, props, iTop, iLeft, iWidth, iHeight, &control);
	}

	if (type) SysFreeString(type);
	if (license) SysFreeString(license);
	if (props) SysFreeString(props);

	return retVal;
}

void CScriptEngine::bye() 
{
	//EXCEPINFO except;
	//HRESULT hr;
	if(gpOutputWindow)
	{
		gpOutputWindow->SendMessage(WM_CLOSE,0,0);
	}
	gbEnterModalLoop=false;
	AfxGetMainWnd()->EndModalLoop(0);
	//::MessageBox(NULL, L"Bye 2", L"EMP", MB_OK);

	/*__try
	{
	if(m_pScript)
		hr=m_pScript->InterruptScriptThread(SCRIPTTHREADID_ALL ,&except,0);
	}
	
	__except (EXCEPTION_EXECUTE_HANDLER)
	{
		//MessageBox(0,L"HERE!",L"HERE",MB_OK);
		gbExitException=true;
	}
	*/
    doWriteDebug(TEXT("6"));
	//AfxGetMainWnd()->EndModalLoop(0);
}

#ifdef kDISPLAY_REFCOUNT_DEBUG_MESSAGES
void CScriptEngine::ListObjects()
{

	DebugStr(L"\n*Listing Objects and refcounts*\n");
	POSITION pos = m_objects.GetStartPosition();
	while( pos != NULL ){
		CScriptObject obj;    
		CString string;
		// Get key ( string ) and value ( pPerson )
		m_objects.GetNextAssoc( pos, string, obj );
		DebugStr(L"OBJECT %s (%lx) [%s/%s]- ",string,obj.pUnk,(obj.dwFlags&OBJ_ISSOURCE)?L"SOURCE":L"NOT SOURCE",(obj.dwFlags&OBJ_ISWINDOW)?L"WINDOW":L"NOT WINDOW");

		if(obj.pUnk)
			DebugRefCount(obj.pUnk,string);
	}

}
#else
void CScriptEngine::ListObjects()
{
}
#endif //kDISPLAY_REFCOUNT_DEBUG_MESSAGES


bool CScriptEngine::LookupObject(wchar_t *name, CScriptObject &obj)
{
	return m_objects.Lookup(name, obj) ? true : false;
}

bool CScriptEngine::LookupObject(CString &name, CScriptObject &obj)
{
	return m_objects.Lookup(name, obj) ? true : false;
}


bool CScriptEngine::LookupObject(CWnd *wnd, CScriptObject &obj)
{
	POSITION pos = m_objects.GetStartPosition();
	while( pos != NULL )
	{
		CString string;
		// Get key ( string ) and value ( pPerson )
		m_objects.GetNextAssoc(pos, string, obj);

		if (obj.pCWnd == wnd)
		{
			return true;
		}
	}

	return false;
}

bool CScriptEngine::LookupObject(HWND wnd, CScriptObject &obj)
{
	POSITION pos = m_objects.GetStartPosition();
	while( pos != NULL )
	{
		CString string;
		// Get key ( string ) and value ( pPerson )
		m_objects.GetNextAssoc(pos, string, obj);

		if (obj.pCWnd->m_hWnd == wnd)
		{
			return true;
		}
	}

	return false;
}


void CScriptEngine::sleep(long milliseconds) 
{
	
	Sleep(milliseconds);

}

void CScriptEngine::SkipBlanks(void)
{
	while (*s && (*s == ' ' || *s == '\t')) ++s;
}

void CScriptEngine::NextToken(void)
{
	/* Get rid of old token */
	if (kTTIdentifier == tokenType || kTTString == tokenType)
	{
		if (strToken)
		{
			SysFreeString(strToken);
			strToken = NULL;
		}
	}

	SkipBlanks();

	if (*s)
	{
		if (ia(*s))
		{
			wchar_t *s2;

			for (s2 = s; ia(*s2) || id(*s2) || '_' == (*s2); ++s2) {}

			strToken = SysAllocStringLen(s, s2 - s);
			s = s2;
			tokenType = kTTIdentifier;
		}
		else if ('"' == *s)
		{
			wchar_t *s2;

			++s;

			for (s2 = s; *s2 && ('"' != *s2); ++s2) {}

			strToken = SysAllocStringLen(s, s2 - s);
			s = s2 + 1;
			if ('"' == *s) ++s;
			tokenType = kTTString;
		}
		else
		{
			tokenType = kTTOperator;
			intToken = *s;
			++s;
		}
	}
	else
	{
		tokenType = kTTEOF;
	}
}

void CScriptEngine::DoDeclare(/*VARIANT FAR &var, */BSTR syntax)
{
	s = syntax;
	DeclKind kind;
	BSTR name = NULL;
	BSTR libName = NULL;
	BSTR libSymbol = NULL;
	BSTR alias = NULL;
	CScriptObject object;
	BSTR error;
	CLibraryDispatch *dispatch;

getFuncOrSub:
	NextToken();

	/* Get Function or Sub */
	if (kTTIdentifier == tokenType && 0 == wcscmpu(strToken, L"Function"))
	{
		kind = kDFunction;
	}
	else if (kTTIdentifier == tokenType && 0 == wcscmpu(strToken, L"Sub"))
	{
		kind = kDProcedure;
	}
	else if (kTTIdentifier == tokenType && 0 == wcscmpu(strToken, L"Private"))
	{
		goto getFuncOrSub;
	}
	else if (kTTIdentifier == tokenType && 0 == wcscmpu(strToken, L"Public"))
	{
		goto getFuncOrSub;
	}
	else
	{
		AfxThrowOleDispatchException(kEXCEPTION_INVALID_ARGUMENTS,TEXT("'Sub' or 'Function' is missing from Declare."));
		return;
	}

	/* Get Name */
	NextToken();
	if (kTTIdentifier == tokenType)
	{
		name = SysAllocString(strToken);
	}
	else
	{
		AfxThrowOleDispatchException(kEXCEPTION_INVALID_ARGUMENTS,TEXT("Name is missing from Declare."));
		if (name) SysFreeString(name);
		return;
	}

	/* Get Library */
	NextToken();
	if (kTTIdentifier == tokenType && 0 == wcscmpu(strToken, L"Lib"))
	{
		NextToken();
		if (kTTString == tokenType)
		{
			wchar_t *runner;
			libName = SysAllocString(strToken);
			_tcslwr(libName);
			libSymbol = SysAllocString(libName);
			_tcslwr(libSymbol);
			runner = libSymbol;

			while (*runner)
			{
				if (ia(*runner) || id(*runner))
				{
				}
				else
				{
					*runner = '_';
				}
				++runner;
			}

			/* See if the DLL exists.  If not, add it */
			if (m_objects.Lookup(libSymbol, object))
			{
			}
			else
			{
				HINSTANCE library = LoadLibrary(libName);
				if (library)
				{
					if (!AddScriptLibrary(libSymbol, library))
					{
						AfxThrowOleDispatchException(kEXCEPTION_INVALID_ARGUMENTS,TEXT("Could not add the library from Declare."));
						if (name) SysFreeString(name);
						if (libName) SysFreeString(libName);
						if (libSymbol) SysFreeString(libSymbol);
						return;
					}
					if (!m_objects.Lookup(libSymbol, object))
					{
						AfxThrowOleDispatchException(kEXCEPTION_INVALID_ARGUMENTS,TEXT("Adding the library from Declare failed."));
						if (name) SysFreeString(name);
						if (libName) SysFreeString(libName);
						if (libSymbol) SysFreeString(libSymbol);
						return;
					}
				}
				else
				{
					//AfxThrowOleDispatchException(kEXCEPTION_INVALID_ARGUMENTS,TEXT("Could not load the library from Declare."));
					if (name) SysFreeString(name);
					if (libName) SysFreeString(libName);
					if (libSymbol) SysFreeString(libSymbol);
					return;
				}
			}
		}
		else
		{
			AfxThrowOleDispatchException(kEXCEPTION_INVALID_ARGUMENTS,TEXT("Library name is missing from Declare."));
			if (name) SysFreeString(name);
			return;
		}
	}
	else
	{
		AfxThrowOleDispatchException(kEXCEPTION_INVALID_ARGUMENTS,TEXT("'Lib' is missing from Declare."));
		if (name) SysFreeString(name);
		return;
	}

	/* Get alias. */
	wchar_t *start = s;
	NextToken();
	if (kTTIdentifier == tokenType && 0 == wcscmpu(strToken, L"Alias"))
	{
		NextToken();

		if (kTTString == tokenType)
		{
			alias = SysAllocString(strToken);
			start = s;
		}
		else
		{
			AfxThrowOleDispatchException(kEXCEPTION_INVALID_ARGUMENTS,TEXT("Alias is missing from Declare."));
			if (name) SysFreeString(name);
			if (libName) SysFreeString(libName);
			if (libSymbol) SysFreeString(libSymbol);
			if (alias) SysFreeString(alias);
		}
	}

	/* Do the rest of the declaration */

	dispatch = (CLibraryDispatch *)object.pUnk;

	error = dispatch -> Declare(start, kind, alias ? alias : name);

	if (error)
	{
		AfxThrowOleDispatchException(kEXCEPTION_INVALID_ARGUMENTS,error);
	}

	/* Add the wrapper code */
	VARIANT vaResult;
	VariantInit(&vaResult);
	CString szExpression = L"";
	CDictionary *dictionary;
	BindingNode *node;
	DISPID ID;

	dictionary = dispatch -> GetDictionary();
	ID = dictionary -> findName(alias ? alias : name, false);
	node = dictionary -> findDLL(ID);

	if (node)
	{

		if (kDFunction == kind)
		{
			szExpression += "Function ";
		}
		else
		{
			szExpression += "Sub ";
		}

		szExpression += name;

		if (node -> DLLfunc.args)
		{
			/* Add the arguments */
			int n = 0;
			Argument *runner;

			szExpression += "(";
			runner = node -> DLLfunc.args;

			while (runner)
			{
				char v[2];
				if (n) szExpression += ", ";
				v[0] = n + 'a';
				v[1] = '\0';

				szExpression += "ByRef ";
				szExpression += v;

				runner = runner -> next;
				++n;
			}

			szExpression += ")";
		}

		szExpression += "\n    ";

		if (kDFunction == kind)
		{
			szExpression += name;
			szExpression += " = ";
		}

		szExpression += libSymbol;
		szExpression += ".";
		if (alias)
		{
			szExpression += alias;
		}
		else
		{
			szExpression += name;
		}

		if (node -> DLLfunc.args)
		{
			/* Add the arguments */
			int n = 0;
			Argument *runner;

			//szExpression += "(";
			if (kDFunction == kind)				//GWH 1/30/07 only Funcs get parens
			{
				szExpression += "(";
			}
			else
			{
				szExpression += " ";
			}									//GWH 1/30/07 end change

			runner = node -> DLLfunc.args;

			while (runner)
			{
				char v[2];
				if (n) szExpression += ", ";
				v[0] = n + 'a';
				v[1] = '\0';

				//szExpression += "ByRef ";
				szExpression += v;

				runner = runner -> next;
				++n;
			}

			//szExpression += ")";
			if (kDFunction == kind)				//GWH 1/30/07 only Funcs get parens
			{
				szExpression += ")";
			}									//GWH 1/30/07 end change
		}

		szExpression += "\nEnd ";

		if (kDFunction == kind)
		{
			szExpression += "Function ";
		}
		else
		{
			szExpression += "Sub ";
		}

		szExpression += "\n";

		//::MessageBox(NULL, szExpression, L"EMP", MB_OK);

		execute(szExpression);


	}
	else
	{
		AfxThrowOleDispatchException(kEXCEPTION_INVALID_ARGUMENTS,TEXT("Internal error: could not find DLL binding node."));
	}

	if (name) SysFreeString(name);
	if (libName) SysFreeString(libName);
	if (libSymbol) SysFreeString(libSymbol);
	if (alias) SysFreeString(alias);

#if 0
	if (VT_DISPATCH != var.vt)
	{
		AfxThrowOleDispatchException(kEXCEPTION_INVALID_ARGUMENTS,TEXT("The fist argument to Declare must be a DLL object."));
		return;
	}

	CLibraryDispatch *dispatch = (CLibraryDispatch *)var.pdispVal;

	if (0xDEADF00D != dispatch -> magicNumber)
	{
		AfxThrowOleDispatchException(kEXCEPTION_INVALID_ARGUMENTS,TEXT("The fist argument to Declare must be a DLL object."));
		return;
	}

	BSTR error;
	error = dispatch -> Declare(syntax);

	if (error)
	{
		AfxThrowOleDispatchException(kEXCEPTION_INVALID_ARGUMENTS,error);
		::SysFreeString(error);
		return;
	}
#endif
}

void CScriptEngine::Testomatic(long hWnd)
{
	HMENU menu = ::CreatePopupMenu();
	HWND window = (HWND)hWnd;
	::AppendMenu(menu, MF_STRING | MF_ENABLED, 1, L"Foo");
	::AppendMenu(menu, MF_STRING | MF_ENABLED, 2, L"Bar");

	::TrackPopupMenuEx(menu, TPM_RETURNCMD, 0, 0, window, NULL);
	::DestroyMenu(menu);
}

void CScriptEngine::UpdateScreen() 
{
	//gpOutputWindow->Invalidate();
   doWriteDebug(TEXT("7"));
	if (gpOutputWindow)
	gpOutputWindow->Update();

	//gpOutputWindow->RedrawWindow(0,0,RDW_VALIDATE|RDW_INTERNALPAINT|RDW_ALLCHILDREN);
}

void CScriptEngine::InternalAddMenuItem(CWnd *pCWnd, CMenu *pMenu, LPCTSTR szElem)
{
	CMenuObject *pcmoMenu;
	COutputWindow *pWnd=(COutputWindow *)pCWnd;
	TCHAR szMenuString[255];
	TCHAR *szMenuID;
	TCHAR szID[100];

	_tcscpy(szMenuString,szElem);
	szMenuID=_tcsstr(szMenuString,kMenuStringDelimiter);
	if(szMenuID)
	{
		*szMenuID=0;
		szMenuID+=_tcslen(kMenuStringDelimiter);//szMenuID now points to the second half of the string.
	}
	else
		szMenuID=szMenuString;

	if(_tcslen(szMenuID)<1)
		szMenuID=szMenuString;
#ifdef _POCKET
   TCHAR szMenuIDBuf[256];
   _tcscpy( szMenuIDBuf, szMenuID );
   szMenuID = szMenuIDBuf;
   int n = 0;
   for( UINT i = 0; i < _tcslen( szMenuString ); i++ )
   {
      if( szMenuString[i] == _T('&'))
         continue;
      if( szMenuString[i] == _T( '\t' ) )
         break;
      szMenuString[n++] = szMenuString[i];
   }
   szMenuString[n] = _T( '\0' );
#endif

	pcmoMenu=new(CMenuObject);
	pcmoMenu->iID=giNextMenuID++;
	pcmoMenu->cstrKey=szMenuID;
	pcmoMenu->cstrText=szMenuString;
	pcmoMenu->hmenuParent=pMenu->m_hMenu;
	if(szMenuString[0]==TEXT('-'))
	{
		void * pMenuTemp;
		_tcscpy(szID,szMenuString);
		while(pWnd->m_menus.Lookup(szID,pMenuTemp))
		{
			wsprintf(szID,TEXT("%s%i"),szID,pcmoMenu->iID);
		}
		pcmoMenu->cstrKey=szID;
		pcmoMenu->dwFlags=MF_SEPARATOR;
	}
	else
		pcmoMenu->dwFlags=MF_STRING;

	pcmoMenu->cstrKey.MakeLower();

	pWnd->m_menus[pcmoMenu->cstrKey]=pcmoMenu;
	pWnd->m_menuIDMap[(void *)pcmoMenu->iID]=pcmoMenu;
	pMenu->AppendMenu(pcmoMenu->dwFlags,pcmoMenu->iID,pcmoMenu->cstrText);
}

void CScriptEngine::SetMenu(LPCTSTR szID, const VARIANT FAR& vItems) 
{
	const VARIANT *pva;
	CString cstrID;
	VARTYPE vt;
	COutputWindow *pWnd;
	CMenuObject *pcmoMenu;
	CMenu *pMenu;
	void *vptr;
	LPSAFEARRAY psa;
	UINT uiDim;
	LONG lUBound, lLBound, lIndex;
	HRESULT hr;
#ifdef _POCKET
   int nMenuDepth = 0;
#endif

   pWnd=gpOutputWindow;

	if(!pWnd)
		return;

	pva=&vItems;

	if(V_VT(pva)&VT_BYREF)
		pva=V_VARIANTREF(pva);

	vt=V_VT(pva);

	//if parameter not supplied or is empty
	if(vt==VT_EMPTY || vt==VT_ERROR || !(vt&VT_ARRAY) )
	{
		TCHAR szBuf[100];
		wsprintf(szBuf,TEXT("Invalid array"));

		AfxThrowOleDispatchException(kEXCEPTION_INVALID_ARGUMENTS,szBuf);
		goto Exit_SetMenu_With_Error;
	}


	//lookup the menu ID to see if it exists.
	cstrID=szID;
	cstrID.MakeLower();

	if(cstrID=="titlebar")
	{//main menu bar
		pMenu=pWnd->GetMenu();
	}
	else
	{
      pMenu = pWnd->GetMenu();
		//vptr=pcmoMenu;
		if(!pWnd->m_menus.Lookup(cstrID,vptr))
		{ //not a defined menu ID, so we can't attach a menu to it.  Should return an error here.
			TCHAR szBuf[100];
			wsprintf(szBuf,TEXT("%s is not a valid menu ID"),cstrID);

			AfxThrowOleDispatchException(kEXCEPTION_INVALID_ARGUMENTS,szBuf);
			goto Exit_SetMenu_With_Error;
		}
		pcmoMenu=(CMenuObject *)vptr;
#ifdef _POCKET
      if( pcmoMenu->hmenuParent == pMenu->m_hMenu )
         nMenuDepth = 1;
      else
         nMenuDepth = INT_MAX;
#endif
		//it's a defined ID, so grab it and make it a submenu if it isn't
		if(pcmoMenu->dwFlags & MF_POPUP)
		{
			pMenu=CMenu::FromHandle(pcmoMenu->hMenu);
		}
		else
		{	//not a submenu, make it so
			CMenu menu;
			CMenu *pParent;
			int iOldID;

			pParent=CMenu::FromHandle(pcmoMenu->hmenuParent);
			
			iOldID=pcmoMenu->iID;
			menu.CreatePopupMenu();
			pWnd->m_menus.RemoveKey(cstrID);
			pWnd->m_menuIDMap.RemoveKey((void *)iOldID);
			pcmoMenu->dwFlags|=MF_POPUP;
			pcmoMenu->hMenu=menu.GetSafeHmenu();
			pWnd->m_menus[cstrID]=pcmoMenu;
			pWnd->m_menuIDMap[pcmoMenu->hMenu]=pcmoMenu;

			pParent->ModifyMenu(iOldID,MF_BYCOMMAND|MF_POPUP,(UINT)pcmoMenu->hMenu,(LPCTSTR)pcmoMenu->cstrText);

			menu.Detach();
			pMenu=CMenu::FromHandle(pcmoMenu->hMenu);
		}
		//pMenu->FromHandle(cmoMenu.hmenuParent);
   }

	//now pMenu points to the menu we are modifying
	//Delete all the items (and their subitems, recursively) in the menu
	doDeleteMenuRecursively(pMenu, pWnd);
#ifdef _POCKET
   if( nMenuDepth < 2 )
   {
      long nMenuCount;
      nMenuCount = ::SendMessage( pWnd->m_wndCommandBar.m_hWnd, TB_BUTTONCOUNT, 0, 0 );
      for( int i = 0; i < nMenuCount; i++ )
         ::SendMessage( pWnd->m_wndCommandBar.m_hWnd, TB_DELETEBUTTON, 0, 0 );
   }
#endif

	//now populate the menu...
	psa = V_ARRAY(pva);
	uiDim = SafeArrayGetDim(psa);

	if (1 != uiDim)
	{
		TCHAR szBuf[100];
		wsprintf(szBuf,TEXT("Invalid array (too many dimensions)"));

		AfxThrowOleDispatchException(kEXCEPTION_INVALID_ARGUMENTS,szBuf);
		goto Exit_SetMenu_With_Error;
	}

	if (FAILED(hr = SafeArrayGetLBound(psa, uiDim, &lLBound)))
	{
		TCHAR szBuf[100];
		wsprintf(szBuf,TEXT("Invalid array (error %lx)"),hr);

		AfxThrowOleDispatchException(kEXCEPTION_INVALID_ARGUMENTS,szBuf);
		goto Exit_SetMenu_With_Error;
	}
	if (FAILED(hr = SafeArrayGetUBound(psa, uiDim, &lUBound)))
	{
		TCHAR szBuf[100];
		wsprintf(szBuf,TEXT("Invalid array (error %lx)"),hr);

		AfxThrowOleDispatchException(kEXCEPTION_INVALID_ARGUMENTS,szBuf);
		goto Exit_SetMenu_With_Error;
	}

	switch(vt) 
	{
		LPTSTR szElem;

	case (VT_ARRAY | VT_BSTR):
	{
		BSTR* rgbstrElems;
		SafeArrayAccessData(psa, (LPVOID*)&rgbstrElems);
		for (lIndex = lLBound; lIndex <= lUBound; lIndex ++)
		{
			USES_CONVERSION;
			szElem = OLE2T(rgbstrElems[lIndex]);
			InternalAddMenuItem(pWnd,pMenu,szElem);
		}
		SafeArrayUnaccessData(psa);
		break;
	}
	case (VT_ARRAY | VT_VARIANT):
	{
		LPVARIANT rgvElems;
		SafeArrayAccessData(psa, (LPVOID*)&rgvElems);
		for (lIndex = lLBound; lIndex <= lUBound; lIndex ++)
		{
			USES_CONVERSION;
			szElem = OLE2T(V_BSTR(&rgvElems[lIndex]));
			InternalAddMenuItem(pWnd,pMenu,szElem);
		}

		SafeArrayUnaccessData(psa);
		break;
	}
	default:
	{
		TCHAR szBuf[100];
		wsprintf(szBuf,TEXT("Invalid array"));

		AfxThrowOleDispatchException(kEXCEPTION_INVALID_ARGUMENTS,szBuf);
		goto Exit_SetMenu_With_Error;
	}
	}//switch

	goto exit_SetMenu_no_error;

Exit_SetMenu_With_Error:

exit_SetMenu_no_error:
	if(pWnd->m_hCommandBar)
	{
#ifdef _POCKET
      if( nMenuDepth < 2 )
      {
         pMenu = pWnd->GetMenu();
         HMENU hMenu = pMenu->m_hMenu;

         TBBUTTON tbButton;
         memset(&tbButton, 0, sizeof(TBBUTTON));
         tbButton.iBitmap = I_IMAGENONE;
         tbButton.fsState = TBSTATE_ENABLED;

         MENUITEMINFO mii;
         TCHAR szMenuItem[256];
         memset(&mii, 0, sizeof(MENUITEMINFO));
         mii.fMask = MIIM_TYPE | MIIM_ID;
         mii.fType = MFT_STRING;
         mii.dwTypeData = szMenuItem;

         for( UINT nIndex = 0; nIndex < pMenu->GetMenuItemCount(); nIndex++ )
         {
            tbButton.dwData = (DWORD)GetSubMenu( hMenu, nIndex );
#  ifndef TBSTYLE_NO_DROPDOWN_ARROW
#    define TBSTYLE_NO_DROPDOWN_ARROW 0x0080
#  endif
            if( tbButton.dwData == NULL )
               tbButton.fsStyle = TBSTYLE_BUTTON | TBSTYLE_AUTOSIZE;
            else
               tbButton.fsStyle = TBSTYLE_DROPDOWN | TBSTYLE_NO_DROPDOWN_ARROW | TBSTYLE_AUTOSIZE;

            mii.cch = 255;
            GetMenuItemInfo( hMenu, nIndex, TRUE, &mii ); // fills szMenuitem

            int n = 0;		
            for (int i =0; i < (int) mii.cch; i++) 
            {
   	         if( szMenuItem[i] == _T('&'))
   		         continue;
   	         szMenuItem[n++] = szMenuItem[i];
            }
            szMenuItem[n] = _T('\0');

            tbButton.iString = (int)szMenuItem;		
            tbButton.idCommand = mii.wID;

            ::SendMessage( pWnd->m_wndCommandBar.m_hWnd, TB_INSERTBUTTON, nIndex, (LPARAM)&tbButton );
         }
      }
#endif
		CommandBar_Show(pWnd->m_hCommandBar,false);
		CommandBar_Show(pWnd->m_hCommandBar,true);
	}

   //InvalidateRect(pWnd->m_hCommandBar,NULL,false);
	//UpdateWindow(pWnd->m_hCommandBar);
	return;
}

void CScriptEngine::chain(LPCTSTR szNewPath, const VARIANT FAR& vNewEnvironment) 
{
	// EXCEPINFO except;
	// HRESULT hr;
	int iKill;

/*	__try
	{
	if(m_pScript)
		hr=m_pScript->InterruptScriptThread(SCRIPTTHREADID_CURRENT ,&except,SCRIPTINTERRUPT_RAISEEXCEPTION );
	}
	__except (EXCEPTION_EXECUTE_HANDLER)
	{
		// MessageBox(0,L"SHOULDN'T BE HERE!",L"HERE",MB_OK);
		// gbExitException=true;
	}
*/
	iKill = doExtractIntFromVariant( &vNewEnvironment, 0 );
// MessageBox( 0, szNewPath, _T( "szNewPath" ), MB_OK );
// if( iKill )
// MessageBox( 0, _T( "TRUE" ), _T( "iKill" ), MB_OK );
// else
// MessageBox( 0, _T( "FALSE" ), _T( "iKill" ), MB_OK );

	// m_pCurrentDocument->DoOnOpenDocument(szNewPath);

	// This flag is an override flag which means that a file should be allowed to open
	// regardless of launch mode..
	gbForceAllowOpen = true;
	if( !theApp.OpenDocumentFile( szNewPath ) )
	{
		// error!
		SetWaitCursor( false );
		// SetCursor( ghCursorNormal ); // **MARCH99 NEW - fixes apparent chain "hang" problem #123
		AfxThrowOleDispatchException( kEXCEPTION_INVALID_ARGUMENTS, IDS_EXCEPTION_CANTLOAD );
		gbForceAllowOpen = false;
		return;
	}
// else
// MessageBox( 0, _T( "Success!" ), _T( "theApp.OpenDocumentFile" ), MB_OK );

	if( iKill )
	{
   doWriteDebug(TEXT("8"));
		if (gpOutputWindow)
		gpOutputWindow->m_bChaining = true;
		// DebugBreak();
		bye(); // now posts a window close message..
		gbOverrideRunActivate = true;
		/*
		old code, pre-bye fix
		AfxGetMainWnd()->SendMessage(WM_COMMAND,MAKEWPARAM(ID_TOOL_RUN,1),0);
		gbOverrideRunActivate=false;
		*/
		AfxGetMainWnd()->PostMessage( WM_COMMAND, MAKEWPARAM( ID_TOOL_RUN, 1 ), 0 );
	}
	else	
	{
   doWriteDebug(TEXT("9"));
		if (gpOutputWindow)
		gpOutputWindow->BringWindowToTop();
		m_pCurrentDocument->DoRunDocument( iKill ? true : false );
	}
}



void CScriptEngine::Break(const VARIANT FAR& Caption, const VARIANT FAR& ExecuteCode) 
{
   doWriteDebug(TEXT("9"));
	CBreakpointDialog dlg(gpOutputWindow);

	dlg.m_pEngine=this;
	dlg.m_ExecuteString=doExtractCStringFromVariant(&ExecuteCode,TEXT(""));
	dlg.m_Caption=doExtractCStringFromVariant(&Caption,dlg.m_Caption);
	//dlg.m_pvarResult=&vaResult;
	dlg.m_pvarResult=NULL;
	dlg.m_pOwner=gpOutputWindow;


	dlg.DoModal();
	if (gpOutputWindow)
	gpOutputWindow->BringWindowToTop();

}

BOOL CScriptEngine::GetKeyPreview() 
{
	return gpOutputWindow ? gpOutputWindow->m_bKeyPreview : false;
}

void CScriptEngine::SetKeyPreview(BOOL bNewValue) 
{
   doWriteDebug(TEXT("10"));
	if (gpOutputWindow)
		gpOutputWindow->m_bKeyPreview=bNewValue?true:false;
}

void CScriptEngine::KillFocus() 
{
   doWriteDebug(TEXT("11"));
	if (gpOutputWindow)
		gpOutputWindow->dlgOutput.SetFocus();
}

BOOL CScriptEngine::GetKeyboardStatus() 
{

	return GetSIPState();

}

void CScriptEngine::SetKeyboardStatus(BOOL bNewValue) 
{
//	SetSIPState((bool)bNewValue);
	SetSIPState( bNewValue ? TRUE : FALSE );
}

void CScriptEngine::WaitCursor(BOOL bWait) 
{//**MARCH99 new
	SetWaitCursor(bWait);
}

short CScriptEngine::InputBox(LPCTSTR Prompt) 
{
   doWriteDebug(TEXT("12"));
	if (gpOutputWindow)
	gpOutputWindow->MessageBox(Prompt);
	return 0;
}

long CScriptEngine::ShellExecute(LPCTSTR verb, LPCTSTR file, const VARIANT FAR& parms) 
{
	CString cstrParms;
	SHELLEXECUTEINFO info;

	cstrParms=doExtractCStringFromVariant(&parms,TEXT(""));
	memset(&info,0,sizeof(SHELLEXECUTEINFO));

	info.cbSize=sizeof(SHELLEXECUTEINFO);
	info.fMask=SEE_MASK_NOCLOSEPROCESS;
	info.hwnd=gpOutputWindow ? gpOutputWindow->m_hWnd : 0;
	info.lpVerb=verb;
	info.lpFile=file;
	info.lpParameters=(LPCTSTR)cstrParms;
	info.nShow=SW_SHOWNORMAL;

	ShellExecuteEx(&info);

	return (long)info.hProcess;
}

long CScriptEngine::eval2(LPCTSTR szExpression, VARIANT *ret) 
{
	int i=0;

	//VARIANT vaResult;
	//VariantInit(&vaResult);
	VariantInit(ret);
	ret->vt=VT_I2;
	ret->iVal=666;

	// TODO: Add your dispatch handler code here

	//return vaResult;
	return 0;
}

BSTR CScriptEngine::GetCurrentPath() 
{
	CString strResult = "";

	if(m_pCurrentDocument)   //shouldn't be null, but just in case...
		strResult=m_pCurrentDocument->GetPathName();

	return strResult.AllocSysString();
}

void CScriptEngine::SetCurrentPath(LPCTSTR lpszNewValue) 
{
	AfxThrowOleDispatchException(kEXCEPTION_READONLY,IDS_EXCEPTION_READONLY);
}

BSTR CScriptEngine::GetTitle() 
{
	CString strResult;

   doWriteDebug(TEXT("13"));
	if (gpOutputWindow) gpOutputWindow -> GetWindowText(strResult);

	return strResult.AllocSysString();
}

void CScriptEngine::SetTitle(LPCTSTR lpszNewValue) 
{
   doWriteDebug(TEXT("14"));
	if (gpOutputWindow) gpOutputWindow->SetWindowText(lpszNewValue);
}


BOOL CScriptEngine::xPlaySound(LPCTSTR szSound, OLE_HANDLE hMod, long dwFlags) 
{

	return PlaySound(szSound,(HINSTANCE)hMod,(DWORD)dwFlags);
}

BSTR CScriptEngine::GetNSBVersion() 
{
	CString strResult;
	
	strResult=kVersionString;
	return strResult.AllocSysString();
}

void CScriptEngine::SetNSBVersion(LPCTSTR lpszNewValue) 
{
	AfxThrowOleDispatchException(kEXCEPTION_READONLY,IDS_EXCEPTION_READONLY);
}

/*
BOOL CScriptEngine::xSetParent(long hChild, long hParent) 
{
	HRESULT hr;
	LPDISPATCH lpDispC, lpDispP;
	CWnd *pCWndC, *pCWndP;

	// First get IDispatch pointer to parent and child
	hr = ((LPUNKNOWN)hChild)->QueryInterface( IID_IDispatch, (void**)&lpDispC );
	if( !SUCCEEDED(hr) )
		return false;
	hr = ((LPUNKNOWN)hParent)->QueryInterface( IID_IDispatch, (void**)&lpDispP );
	if( !SUCCEEDED(hr) )
		return false;

	// Get pointers to CWnds if possible
	pCWndC = (CWnd *)CCmdTarget::FromIDispatch( lpDispC );
	pCWndP = (CWnd *)CCmdTarget::FromIDispatch( lpDispP );
	if( pCWndC == NULL || pCWndP == NULL )
		return false;

	// Now try setting the parent
	if( SetParent( pCWndC->m_hWnd, pCWndP->m_hWnd ) )
		return SetWindowPos( pCWndC->m_hWnd, HWND_TOP, 0, 0, 0, 0, SWP_NOSIZE|SWP_NOMOVE );
	return false;
	
	
	if( !hChild || !hParent )
		return false;
	if( SetParent( (HWND)hChild, (HWND)hParent ) )
		return SetWindowPos( (HWND)hChild, HWND_TOP, 0, 0, 0, 0, SWP_NOSIZE|SWP_NOMOVE );
	else
		return false;
}
*/

long CScriptEngine::GetLastHWND() 
{
	return (long)m_hLastHWND;
}

void CScriptEngine::ShowOKButton(BOOL bShow) 
{
#if _WIN32_WCE >= 300 && defined(_POCKET)
   doWriteDebug(TEXT("15"));
	if (gpOutputWindow)
	{
		gpOutputWindow->m_bOKButton = bShow;
		gpOutputWindow->ShowDoneButton( bShow );
	}
#endif
}

BSTR CScriptEngine::xGetCommandLine() 
{
	CString strResult;

	MessageBox( 0, theApp.m_strCommandLine, _T("Script: Command Line"), 0 );
	//strResult = GetCommandLine();

	return strResult.AllocSysString();
}

long CScriptEngine::GetHWND(LPUNKNOWN obj)
{
	LPDISPATCH lpDisp;
	CWnd *pCWnd;

	if( SUCCEEDED(obj->QueryInterface( IID_IDispatch, (void**)&lpDisp )) )
		if( pCWnd = (CWnd *)CCmdTarget::FromIDispatch( lpDisp ) )
			return (long)pCWnd->m_hWnd;
	return 0;
}

BOOL CScriptEngine::xSetParent(LPUNKNOWN lpUnkC, LPUNKNOWN lpUnkP) 
{
	HRESULT hr;
	LPDISPATCH lpDispC, lpDispP;
	CWnd *pCWndC, *pCWndP;

	// First get IDispatch pointer to parent and child
	hr = lpUnkC->QueryInterface( IID_IDispatch, (void**)&lpDispC );
	if( !SUCCEEDED(hr) )
		return false;
	hr = lpUnkP->QueryInterface( IID_IDispatch, (void**)&lpDispP );
	if( !SUCCEEDED(hr) )
		return false;

	// Get pointers to CWnds if possible
	pCWndC = (CWnd *)CCmdTarget::FromIDispatch( lpDispC );
	pCWndP = (CWnd *)CCmdTarget::FromIDispatch( lpDispP );
	if( pCWndC == NULL || pCWndP == NULL )
		return false;

	// Now try setting the parent
	if( SetParent( pCWndC->m_hWnd, pCWndP->m_hWnd ) )
		return SetWindowPos( pCWndC->m_hWnd, HWND_TOP, 0, 0, 0, 0, SWP_NOSIZE|SWP_NOMOVE );
	return false;
}

void CScriptEngine::DoEvents() 
{
	MSG myMsg;

	if( PeekMessageW( &myMsg, 0, 0, 0, 1 ) )
	{
		TranslateMessage( &myMsg );
		DispatchMessage( &myMsg );
	}
}

long CScriptEngine::GetWaveVolume() 
{
	unsigned long vol;

	waveOutGetVolume( 0, &vol );

	return vol;
}

void CScriptEngine::SetWaveVolume(long nNewValue) 
{
	waveOutSetVolume( 0, nNewValue );
}

void CScriptEngine::doSendKey(short KeyState, short Char) 
{
	BOOL tmp;
	UINT k = KeyState, c = Char;
	tmp = PostKeybdMessage( 0, 0, k, 1, &k, &c );
	DoEvents();
}

/*void CScriptEngine::ShowMenuBar(BOOL bShow) 
{
	HWND handle; // = FindWindow( _T("menu_worker"), 0 );
//	if( handle != NULL )
//		ShowWindow( handle, bShow ? 1 : 0 );
	handle = SHFindMenuBar( gpOutputWindow->m_hWnd );
	ShowWindow( handle, bShow ? SW_SHOW : SW_HIDE );
//	SHFullScreen( gpOutputWindow->m_hWnd, bShow ? SHFS_SHOWSTARTICON : SHFS_HIDESTARTICON );
}

void CScriptEngine::ShowTaskBar(BOOL bShow) 
{
	SHFullScreen( gpOutputWindow->m_hWnd, bShow ? SHFS_SHOWTASKBAR : SHFS_HIDETASKBAR );
}

void CScriptEngine::ShowSIPButton(BOOL bShow) 
{
	SHFullScreen( gpOutputWindow->m_hWnd, bShow ? SHFS_SHOWSIPBUTTON : SHFS_HIDESIPBUTTON );
}

void CScriptEngine::ShowFullScreen(BOOL bShow) 
{
	if( bShow )
		SHFullScreen( gpOutputWindow->m_hWnd, SHFS_HIDETASKBAR | SHFS_HIDESIPBUTTON );
	else
		SHFullScreen( gpOutputWindow->m_hWnd, SHFS_SHOWTASKBAR | SHFS_SHOWSIPBUTTON );

	MoveWindow( gpOutputWindow->m_hWnd,
				0,
				bShow ? 0 : 26,
				GetSystemMetrics( SM_CXSCREEN ),
				GetSystemMetrics( SM_CYSCREEN ) - ( bShow ? 0 : 52 ),
				true );
	ShowMenuBar( !bShow );
}

void CScriptEngine::ShowStartIcon(BOOL bShow) 
{
	SHFullScreen( gpOutputWindow->m_hWnd, bShow ? SHFS_SHOWSTARTICON : SHFS_HIDESTARTICON );
}

#define SHFS_SHOWTASKBAR            0x0001
#define SHFS_HIDETASKBAR            0x0002
#define SHFS_SHOWSIPBUTTON          0x0004
#define SHFS_HIDESIPBUTTON          0x0008
#define SHFS_SHOWSTARTICON          0x0010
#define SHFS_HIDESTARTICON          0x0020
  // Not real constants, MMD defined
#define SHFS_SHOWMENUBAR            0x1000
#define SHFS_HIDEMENUBAR          0x2000
*/
#define NSB_SHOWMENUBAR	0x1000
#define NSB_HIDEMENUBAR 0x2000
#define MENUBAR_HT 26
#define TASKBAR_HT 26

BOOL CScriptEngine::ShowFullScreen(long nFlags) 
{
#if _WIN32_WCE >= 300 && defined(_POCKET)
	RECT rMenuRect;
	HWND lWnd, lMenuWnd;
	long lMenuHeight;

	lMenuWnd = 0;

	if(nFlags){
		lWnd = FindWindow(TEXT("menu_worker"), TEXT(""));
		if(lWnd != 0) ShowWindow(lWnd, SW_HIDE);

		lWnd = gpOutputWindow->m_hWnd;

		if(lWnd != 0){
#if _WIN32_WCE >= 310 //SHFindMenuBar function does not exist on PocketPC devices
			lMenuWnd = SHFindMenuBar(lWnd);
#endif
			if(lMenuWnd != 0){
				GetWindowRect(lMenuWnd, &rMenuRect);
				ShowWindow(lMenuWnd, SW_HIDE);
				lMenuHeight = rMenuRect.bottom - rMenuRect.top;
			}else{
				lMenuHeight = 26;
			}
				
			SHFullScreen(lWnd, SHFS_HIDETASKBAR | SHFS_HIDESIPBUTTON); 

			SetForegroundWindow(lWnd);
			MoveWindow(lWnd, 0, 0, GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN) + lMenuHeight, 0);
		}
	}else if(nFlags == 0){
		lWnd = gpOutputWindow->m_hWnd;
		if(lWnd != 0){
#if _WIN32_WCE >= 310 
			lMenuWnd = SHFindMenuBar((HWND)lWnd);
#endif
			if(lMenuWnd != 0){
				ShowWindow(lMenuWnd, SW_SHOW);
				GetWindowRect(lMenuWnd, &rMenuRect);
				lMenuHeight = rMenuRect.bottom - rMenuRect.top;
			}else{
				lMenuHeight = 26;
			}
				
			SHFullScreen((HWND)lWnd, SHFS_SHOWTASKBAR | SHFS_SHOWSIPBUTTON); 

			SetForegroundWindow((HWND)lWnd);
			MoveWindow((HWND)lWnd, 0, lMenuHeight, GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN) + lMenuHeight, 0);
		}

		lWnd = FindWindow(TEXT("menu_worker"), TEXT(""));
		if(lWnd != 0) ShowWindow(lWnd, SW_SHOW);
	}
#endif

//#if 1 //_WIN32_WCE >= 300 && defined(_POCKET)
//GWH: This method does not appear to work with MFC 
//	DoFullScreen( nFlags != 0 );
//#endif

	return S_OK;

}

BOOL CScriptEngine::RunAppAtTime(LPCTSTR lpszApp, short yr, short mo, short dy, short hr, short mn, short sc) 
{
	SYSTEMTIME lpTime;

	memset(&lpTime, 0, sizeof(SYSTEMTIME));
	lpTime.wYear=yr;
	lpTime.wMonth=mo;
	lpTime.wDay=dy;
	lpTime.wHour=hr;
	lpTime.wMinute=mn;
	lpTime.wSecond=sc;

	return CeRunAppAtTime( (TCHAR *)lpszApp, &lpTime );
}

BOOL CScriptEngine::RunAppAtEvent(LPCTSTR lpszApp, long nEvent) 
{
	return CeRunAppAtEvent( (TCHAR *)lpszApp, nEvent );
}

BSTR CScriptEngine::GetCommandLine() 
{
	CString strResult;

	strResult = theApp.m_strCommandLine;

	return strResult.AllocSysString();
}

long CScriptEngine::GetAppHWnd() 
{
   doWriteDebug(TEXT("17"));
	if( gpOutputWindow )
		return (long)gpOutputWindow->m_hWnd;
	return 0;
}

BSTR CScriptEngine::GetSerialNumber() 
{
	CString strResult;

	DWORD dwOutBytes;
	const int nBuffSize = 4096;
	byte arrOutBuff[nBuffSize];

	BOOL bRes = ::KernelIoControl( IOCTL_HAL_GET_DEVICEID, 0, 0, arrOutBuff, nBuffSize, &dwOutBytes );

	if (bRes)
	{
		CString strDeviceInfo;
		for( unsigned int i = 0; i < dwOutBytes; i++ )
		{
			CString strNextChar;
			strNextChar.Format( _T("%02X"), arrOutBuff[i] );
			strDeviceInfo += strNextChar;
		}
		strResult = strDeviceInfo.Mid( 40, 2 ) + strDeviceInfo.Mid( 45, 9 ) + strDeviceInfo.Mid( 70, 6 );
	}
	else
		strResult = _T("");

	return strResult.AllocSysString();
}

BOOL CScriptEngine::GetQueryUnloadCancel() 
{
	return m_bQueryUnloadCancel;
}

void CScriptEngine::SetQueryUnloadCancel( BOOL bNewValue )
{
	m_bQueryUnloadCancel = bNewValue;
}

BSTR CScriptEngine::SpecialFolder(long nFolder, const VARIANT FAR& fCreate) 
{
	wchar_t buf[MAX_PATH];
	bool create = false;

	if(fCreate.vt!=VT_EMPTY)
	{
		create = fCreate.boolVal ? true : false;
	}

	//GWH: To get this to compile for HPC2000 and PocketPC devices, I had to copy the definitions
	//for SHGetSpecialFolderPath from ShellApi.h from 
	//Pocket PC 2002 SDK to the HPC 2000 and Pocket PC SDK.
#if (_WIN32_WCE>=300) 
	SHGetSpecialFolderPath(NULL, buf, nFolder, create);
#endif

	CString strResult(buf);

	return strResult.AllocSysString();

}

long CScriptEngine::xSendMessage(long hwnd, long wMsg, long wParam, long lParam) 
{
	return SendMessage((HWND)hwnd, wMsg, (WPARAM)wParam, (LPARAM)lParam);
}